/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.network.qasn.asndatasource.AsnDelayLoadObjStruct;
import com.huawei.network.qasn.asndatasource.AsnDelayLoadObjStructList;
import com.huawei.network.qasn.asndatasource.AsnDelayLoadReq;
import com.huawei.network.qasn.asndatasource.AsnDelayLoadRsp;
import com.huawei.network.qasn.asndatasource.AsnDelayLoadStruct;
import com.huawei.network.qasn.asndatasource.AsnObjTreeDataStruct;
import com.huawei.network.qasn.asndatasource.AsnObjTreeDataStructList;
import com.huawei.network.qasn.asnutil.AsnIntList;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FrameUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoQueryObjectTreeDataTask {
    public static final int FUNCID_LINKSEARCH = 11534980;
    public static final int FUNCTION_ID_ALARM_PROJECT = 11534983;
    public static final int FUNCTION_ID_ALARM_SOURCE = 11534978;
    public static final int FUNCTION_ID_LINK_MANAGEMENT = 11534979;
    public static final int OBJECT_TYPE_FRAME = 7;
    public static final int OBJECT_TYPE_NE = 5;
    public static final int OBJECT_TYPE_PORT = 20;
    public static final int OBJECT_TYPE_SLOT = 10;
    public static final int OBJECT_TYPE_SUBSLOT = 15;
    private static final Logger logger = LoggerFactory.getLogger(DoQueryObjectTreeDataTask.class);
    private int queryResultType = 0;
    private AsnDelayLoadReq req;
    private AsnDelayLoadRsp resp;
    private List<? extends PhyEntity> resultList = null;

    public DoQueryObjectTreeDataTask(AsnDelayLoadReq req, AsnDelayLoadRsp resp) {
        this.req = req;
        this.resp = resp;
    }

    private static IDao getDao() {
        return DaoFactory.getInstance().getDefaultVmfDao(null);
    }

    public void parseResultLst(List<? extends PhyEntity> resultList) {
        AsnDelayLoadStruct respDelayObjStruct = new AsnDelayLoadStruct();
        AsnObjTreeDataStructList respObjDataLst = new AsnObjTreeDataStructList();
        for (PhyEntity phyEntity : resultList) {
            this.setFDNForPhyEntity(phyEntity);
            AsnObjTreeDataStruct dataStruct = new AsnObjTreeDataStruct();
            dataStruct.node.fdn = phyEntity.getFdn().getBytes();
            Object inventoryUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
            dataStruct.node.name = null != inventoryUtilExtPoint ? (phyEntity.getEntPosition() + "-" + phyEntity.getVendorType()).getBytes() : phyEntity.getName().getBytes();
            dataStruct.node.value = BigInteger.valueOf(0L);
            dataStruct.hasChildren = BigInteger.valueOf(1L);
            dataStruct.type = BigInteger.valueOf(this.queryResultType);
            respObjDataLst.add((Object)dataStruct);
        }
        respDelayObjStruct.delayLoadDataList = respObjDataLst;
        respDelayObjStruct.delayLoadSerial = BigInteger.valueOf(0L);
        this.resp.delayLoadDataList.add((Object)respDelayObjStruct);
    }

    public void query() {
        AsnDelayLoadObjStructList objList = this.req.objList;
        int functionID = this.req.funcId.intValue();
        if (11534983 != functionID && 11534978 != functionID && 11534980 != functionID) {
            return;
        }
        AsnDelayLoadObjStruct asnDelayObjStruct = (AsnDelayLoadObjStruct)objList.get(0);
        AsnIntList asnResIDList = asnDelayObjStruct.objIDList;
        int objectType = asnDelayObjStruct.type.intValue();
        ArrayList<Integer> resIDList = new ArrayList<Integer>();
        for (int i = 0; asnResIDList != null && i < asnResIDList.size(); ++i) {
            BigInteger resID = (BigInteger)asnResIDList.get(i);
            resIDList.add(resID.intValue());
        }
        try {
            switch (objectType) {
                case 5: {
                    Object inventoryUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
                    if (null != inventoryUtilExtPoint) {
                        this.resultList = (List)this.queryBoardsByNE(resIDList);
                        break;
                    }
                    this.resultList = (List)this.queryFramesByDevice(resIDList);
                    break;
                }
                case 7: {
                    this.resultList = (List)this.queryBoardsByFrame(resIDList);
                    break;
                }
                case 10: {
                    this.resultList = (List)this.querySubCardsByBoard(resIDList);
                    break;
                }
                case 15: {
                    this.resultList = (List)this.queryPortsBySubCard(resIDList);
                }
                default: {
                    logger.info("objectType can't handle. objectType=" + objectType);
                }
            }
            this.parseResultLst(this.resultList);
            this.resp.result.isSuccess = true;
            this.resp.result.retCode = BigInteger.valueOf(0L);
        }
        catch (VMFException e) {
            logger.error("query objectTree Data error", (Throwable)e);
            this.resp.result.retCode = BigInteger.valueOf(1L);
        }
    }

    public Collection<Board> queryBoardsByFrame(List<Integer> resID) throws VMFException {
        Board card = new Board();
        card.setDevID(resID.get(0));
        card.setChassisID(resID.get(1));
        IDao dao = DoQueryObjectTreeDataTask.getDao();
        return dao.queryByKey(Board.class, Arrays.asList(card), false);
    }

    public Collection<Board> queryBoardsByNE(List<Integer> resID) throws VMFException {
        IDao dao = DoQueryObjectTreeDataTask.getDao();
        return dao.queryByNeID(Board.class, resID, false);
    }

    public Collection<Chassis> queryFramesByDevice(List<Integer> resID) throws VMFException {
        IDao dao = DoQueryObjectTreeDataTask.getDao();
        return dao.queryByNeID(Chassis.class, resID, false);
    }

    public Collection<Port> queryPortsBySubCard(List<Integer> resID) throws VMFException {
        Port port = new Port();
        port.setDevID(resID.get(0));
        port.setChassisID(resID.get(1));
        port.setSlotID(resID.get(2));
        port.setSubSlotID(resID.get(4));
        IDao dao = DoQueryObjectTreeDataTask.getDao();
        return dao.queryByKey(Port.class, Arrays.asList(port), false);
    }

    public Collection<SubCard> querySubCardsByBoard(List<Integer> resID) throws VMFException {
        SubCard card = new SubCard();
        card.setDevID(resID.get(0));
        card.setChassisID(resID.get(1));
        card.setSlotID(resID.get(2));
        IDao dao = DoQueryObjectTreeDataTask.getDao();
        return dao.queryByKey(SubCard.class, Arrays.asList(card), false);
    }

    public PhyEntity setFDNForPhyEntity(PhyEntity entity) {
        FrameUniResIDParser parser = null;
        if (entity instanceof Chassis) {
            Chassis chassis = (Chassis)entity;
            parser = new FrameUniResIDParser(chassis.getDevID().intValue(), chassis.getChassisID().intValue());
            this.queryResultType = 7;
        } else if (entity instanceof Board) {
            Board board = (Board)entity;
            parser = new SlotUniResIDParser(board.getDevID().intValue(), board.getChassisID().intValue(), board.getSlotID().intValue());
            this.queryResultType = 10;
        } else if (entity instanceof SubCard) {
            SubCard card = (SubCard)entity;
            parser = new SlotUniResIDParser(card.getDevID().intValue(), card.getChassisID().intValue(), card.getSlotID().intValue(), card.getSubSlotID(), card.getSubSlotID());
            this.queryResultType = 15;
        } else {
            Port port = (Port)entity;
            parser = new PortUniResIDParser(port.getDevID().intValue(), port.getChassisID().intValue(), port.getSlotID().intValue(), port.getSubSlotID(), port.getParentRelPosition().intValue(), port.getName());
            this.queryResultType = 20;
        }
        entity.setFdn(parser.serialize());
        return entity;
    }
}

