/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.translation.asn.FInventoryAsnFrameInfoTranslator;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityGetInvResInfoRsp;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import com.huawei.vmf.adaptor.inventory.asn.AsnEntityGetEntityResInfoReq;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoQueryFrameInfoTask {
    private static Logger logger = LoggerFactory.getLogger(DoQueryFrameInfoTask.class);
    private IDeviceService deviceService;
    private AsnEntityGetEntityResInfoReq req;
    private AsnEmlEntityGetInvResInfoRsp rsp;
    private IAsnTranslator<AsnEmlEntityInvResInfo, Chassis> translator;

    public DoQueryFrameInfoTask(AsnEntityGetEntityResInfoReq req, AsnEmlEntityGetInvResInfoRsp rsp) {
        this.req = req;
        this.rsp = rsp;
        this.translator = new FInventoryAsnFrameInfoTranslator();
    }

    public Chassis decode() {
        Chassis chassis = new Chassis();
        chassis.setDevID(Integer.valueOf(this.req.iDevID.intValue()));
        chassis.setParentRelPosition(Integer.valueOf(this.req.iFrameNum.intValue()));
        return chassis;
    }

    public Chassis getChassis() throws VMFException {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection chassises = dao.queryByKey(Chassis.class, Arrays.asList(this.decode()), false);
        return chassises.isEmpty() ? null : (Chassis)chassises.iterator().next();
    }

    public void query() {
        this.rsp.iErrCode = BigInteger.valueOf(0L);
        try {
            Chassis chassis = this.getChassis();
            if (null == chassis) {
                return;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("devTypeName", this.getDeviceService().getDevNameByID(this.req.iDevID.intValue()));
            AsnTranslationContext context = new AsnTranslationContext(properties);
            AsnEmlEntityInvResInfo resInfo = new AsnEmlEntityInvResInfo();
            this.translator.encode((Object)chassis, (FStruct)resInfo, (IAsnTranslationContext)context);
            this.rsp.oEntityResInfo = resInfo;
        }
        catch (VMFException e) {
            logger.error("invertory query frameinfo failed: ", (Throwable)e);
            this.rsp.iErrCode = BigInteger.valueOf(e.getErrorCode());
        }
    }

    private IDeviceService getDeviceService() throws VMFException {
        if (null == this.deviceService) {
            this.deviceService = Activator.getDeviceService();
        }
        return this.deviceService;
    }
}

