/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.translation.asn.FInventoryAsnFrameInfoTranslator;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityGetInvResInfoListRsp;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import com.huawei.vmf.adaptor.inventory.asn.AsnEntityGetEntityResInfoReq;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DoQueryFrameInfoListTask {
    private static Logger logger = LoggerFactory.getLogger(DoQueryFrameInfoListTask.class);
    private IDeviceService deviceService;
    private AsnEntityGetEntityResInfoReq req;
    private AsnEmlEntityGetInvResInfoListRsp rsp;
    private IAsnTranslator<AsnEmlEntityInvResInfo, Chassis> translator;

    public DoQueryFrameInfoListTask(AsnEntityGetEntityResInfoReq req, AsnEmlEntityGetInvResInfoListRsp rsp) {
        this.req = req;
        this.rsp = rsp;
        this.translator = new FInventoryAsnFrameInfoTranslator();
    }

    public Collection<Chassis> getChassisList() throws VMFException {
        int devID = this.req.iDevID.intValue();
        Chassis chassis = new Chassis();
        chassis.setDevID(Integer.valueOf(devID));
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        return dao.queryByNeID(Chassis.class, Arrays.asList(devID), false);
    }

    public void query() {
        this.rsp.iErrCode = BigInteger.valueOf(0L);
        try {
            Collection<Chassis> chassises = this.getChassisList();
            if (CollectionUtils.isEmpty(chassises)) {
                return;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("devTypeName", this.getDeviceService().getDevNameByID(this.req.iDevID.intValue()));
            AsnTranslationContext context = new AsnTranslationContext(properties);
            ArrayList<AsnEmlEntityInvResInfo> oEntityResInfoLst = new ArrayList<AsnEmlEntityInvResInfo>();
            AsnEmlEntityInvResInfo oEntityResInfo = null;
            for (Chassis chassis : chassises) {
                oEntityResInfo = new AsnEmlEntityInvResInfo();
                this.translator.encode((Object)chassis, (FStruct)oEntityResInfo, (IAsnTranslationContext)context);
                oEntityResInfoLst.add(oEntityResInfo);
            }
            this.rsp.lstEntityInfo.addAll(oEntityResInfoLst);
        }
        catch (VMFException e) {
            this.rsp.iErrCode = BigInteger.valueOf(e.getErrorCode());
            logger.error("Invertory query frameinfolist failed:", (Throwable)e);
        }
    }

    private IDeviceService getDeviceService() throws VMFException {
        if (null == this.deviceService) {
            this.deviceService = Activator.getDeviceService();
        }
        return this.deviceService;
    }
}

