/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.translation.asn.FInventoryAsnCardInfoTranslator;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityGetInvResInfoListRsp;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import com.huawei.vmf.adaptor.inventory.asn.AsnEntityGetEntityResInfoReq;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DoQueryCardInfoListTask {
    private static Logger logger = LoggerFactory.getLogger(DoQueryCardInfoListTask.class);
    private IDeviceService deviceService;
    private AsnEntityGetEntityResInfoReq req;
    private AsnEmlEntityGetInvResInfoListRsp rsp;
    private IAsnTranslator<AsnEmlEntityInvResInfo, Card> translator;

    public DoQueryCardInfoListTask(AsnEntityGetEntityResInfoReq req, AsnEmlEntityGetInvResInfoListRsp rsp) {
        this.req = req;
        this.rsp = rsp;
        this.translator = new FInventoryAsnCardInfoTranslator();
    }

    public Collection<Board> getCardList() throws VMFException {
        int devID = this.req.iDevID.intValue();
        int chassisID = this.req.iFrameNum.intValue();
        Board board = new Board();
        board.setDevID(Integer.valueOf(devID));
        if (chassisID >= 0) {
            board.setChassisID(Integer.valueOf(chassisID));
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        return dao.queryByKey(Board.class, Arrays.asList(board), false);
    }

    public void query() {
        this.rsp.iErrCode = BigInteger.valueOf(0L);
        try {
            Collection<Board> cards = this.getCardList();
            if (CollectionUtils.isEmpty(cards)) {
                return;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("devTypeName", this.getDeviceService().getDevNameByID(this.req.iDevID.intValue()));
            AsnTranslationContext context = new AsnTranslationContext(properties);
            ArrayList<AsnEmlEntityInvResInfo> oEntityResInfoLst = new ArrayList<AsnEmlEntityInvResInfo>();
            AsnEmlEntityInvResInfo oEntityResInfo = null;
            for (Board card : cards) {
                if (Integer.valueOf(4).equals(card.getOperStatus())) continue;
                oEntityResInfo = new AsnEmlEntityInvResInfo();
                this.translator.encode((Object)card, (FStruct)oEntityResInfo, (IAsnTranslationContext)context);
                oEntityResInfoLst.add(oEntityResInfo);
            }
            this.rsp.lstEntityInfo.addAll(oEntityResInfoLst);
        }
        catch (VMFException e) {
            logger.error("inventory query cardlist failed:", (Throwable)e);
            this.rsp.iErrCode = BigInteger.valueOf(e.getErrorCode());
        }
    }

    private IDeviceService getDeviceService() throws VMFException {
        if (null == this.deviceService) {
            this.deviceService = Activator.getDeviceService();
        }
        return this.deviceService;
    }
}

