/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.inventory.task.IQSetTask;
import com.huawei.vmf.adapter.inventory.translation.asn.IQAsnSetVmfMoTranslator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQSetVmfMoTask<T extends VmfMO, ReqAsnType extends FStruct>
implements IQSetTask {
    protected QAsnErrInfoReturn asnErrInfo;
    protected ReqAsnType asnReq;
    protected IQAsnSetVmfMoTranslator<ReqAsnType> translator = null;
    private static Logger logger = LoggerFactory.getLogger(AbstractQSetVmfMoTask.class);

    public AbstractQSetVmfMoTask(QAsnErrInfoReturn asnErrInfo, ReqAsnType asnReq, IQAsnSetVmfMoTranslator<ReqAsnType> translator) {
        this.asnErrInfo = asnErrInfo;
        this.asnReq = asnReq;
        this.translator = translator;
    }

    @Override
    public void execute() {
        try {
            this.operate(this.decode());
        }
        catch (VMFException e) {
            this.handleError(e);
            logger.error("set vmfmo failed :", (Throwable)e);
        }
    }

    public void operate(List<? extends VmfMO> moList) throws VMFException {
        this.update(moList);
    }

    public List<? extends VmfMO> decode() throws VMFException {
        return this.translator.decode(this.asnReq, this.getAsnTranslationContext());
    }

    public abstract IAsnTranslationContext getAsnTranslationContext();

    public void update(List<? extends VmfMO> phyEntitylst) throws VMFException {
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = phyEntitylst.iterator().next().getClass();
        IMOChangeRecord record = ctx.addChangeRecord(clazz);
        for (VmfMO vmfMO : phyEntitylst) {
            record.addModify((Object)vmfMO, dao.getPersistentProperties(clazz));
        }
        dao.merge(clazz, false);
        this.asnErrInfo.result = 0;
    }

    public void handleError(VMFException e) {
        QAsnErrInfo err = this.getErrorInfo(e.getErrorCode());
        this.responseError(err);
    }

    public QAsnErrInfo getErrorInfo(int errorCode) {
        QAsnErrInfo err = new QAsnErrInfo();
        err.errCode = errorCode;
        return err;
    }

    private void responseError(QAsnErrInfo err) {
        if (this.asnErrInfo != null) {
            if (this.asnErrInfo.errList == null) {
                this.asnErrInfo.errList = new QAsnErrInfoList();
            }
            this.asnErrInfo.result = 1107499878;
            this.asnErrInfo.errList.add((Object)err);
        }
    }
}

