/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.communicate.core.MSGHead;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.inventory.task.IQSetTask;
import com.huawei.vmf.adapter.inventory.translation.asn.IQAsnSetTranslator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQSetTask<T extends PhyEntity, ReqAsnType extends FStruct>
implements IQSetTask {
    private static Logger logger = LoggerFactory.getLogger(AbstractQSetTask.class);
    protected QAsnErrInfoReturn asnErrInfo;
    protected ReqAsnType asnReq;
    protected MSGHead mheader;
    protected IQAsnSetTranslator<ReqAsnType> translator;

    protected AbstractQSetTask(ReqAsnType asnReq, QAsnErrInfoReturn asnErrInfo, IQAsnSetTranslator<ReqAsnType> translator) {
        this.asnReq = asnReq;
        this.asnErrInfo = asnErrInfo;
        this.translator = translator;
    }

    protected AbstractQSetTask(ReqAsnType asnReq, QAsnErrInfoReturn asnErrInfo, MSGHead mheader, IQAsnSetTranslator<ReqAsnType> translator) {
        this.asnReq = asnReq;
        this.asnErrInfo = asnErrInfo;
        this.mheader = mheader;
        this.translator = translator;
    }

    public List<? extends PhyEntity> decode() {
        return this.translator.decode(this.asnReq, this.getAsnTranslationContext());
    }

    @Override
    public void execute() {
        try {
            this.update(this.decode());
        }
        catch (VMFException e) {
            this.handleError(e);
            logger.error("set phyentityinfo failed :", (Throwable)e);
        }
    }

    public abstract IAsnTranslationContext getAsnTranslationContext();

    public QAsnErrInfo getErrorInfo(int errorCode) {
        QAsnErrInfo err = new QAsnErrInfo();
        err.errCode = errorCode;
        return err;
    }

    public void handleError(VMFException e) {
        QAsnErrInfo err = this.getErrorInfo(e.getErrorCode());
        this.responseError(err);
    }

    public void update(List<? extends PhyEntity> phyEntitylst) throws VMFException {
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        Class<?> clazz = phyEntitylst.iterator().next().getClass();
        IMOChangeRecord record = ctx.addChangeRecord(clazz);
        for (PhyEntity phyEntity : phyEntitylst) {
            record.addModify((Object)phyEntity, dao.getPersistentProperties(clazz));
        }
        dao.merge(clazz, false);
        MOChangePublisher.getInstance().notifyChanges(ctx);
        this.asnErrInfo.result = 0;
    }

    private void responseError(QAsnErrInfo err) {
        if (this.asnErrInfo != null) {
            if (this.asnErrInfo.errList == null) {
                this.asnErrInfo.errList = new QAsnErrInfoList();
            }
            this.asnErrInfo.result = 1107499878;
            this.asnErrInfo.errList.add((Object)err);
        }
    }
}

