/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnGetSlotInfoRsp;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnNESlotInfo;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSlotInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQQuerySingleMoTypeTask;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Holder;
import com.huawei.vmf.adapter.fservice.inventory.model.LogicBoard;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Slot;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.inventory.model.SubSlot;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnNESlotInfoTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;

public abstract class AbstractQQuerySlotInfoTask<ReqAsnType extends FStruct>
extends AbstractQQuerySingleMoTypeTask<ReqAsnType, QAsnGetSlotInfoRsp, Holder> {
    protected AbstractQQuerySlotInfoTask(AbstractAsnTranslator asnTranslator) {
        super((IAsnTranslator)asnTranslator);
    }

    protected abstract Map<Class<? extends PhyEntity>, List<? extends PhyEntity>> decodeIndexs(ReqAsnType var1, IAsnTranslationContext var2) throws VMFException;

    protected Class<? extends FStruct> getQueryAsnType() {
        return QAsnNESlotInfo.class;
    }

    protected void handleErrorResult(VMFException e, QAsnGetSlotInfoRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnGetSlotInfoRsp rsp) {
        this.initRspResult(rsp.result);
    }

    protected Collection<?> queryMoInfo(ReqAsnType req, QAsnGetSlotInfoRsp rsp, Task task) throws VMFException {
        Collection logicBoards;
        AsnTranslationContext context = new AsnTranslationContext();
        Map<Class<PhyEntity>, List<PhyEntity>> moIndexes = this.decodeIndexs(req, (IAsnTranslationContext)context);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection slots = dao.queryByKey(Slot.class, moIndexes.get(Slot.class), false);
        Collection boards = dao.queryByKey(Board.class, moIndexes.get(Board.class), false);
        Collection subCards = dao.queryByKey(SubCard.class, moIndexes.get(SubCard.class), false);
        Collection<SubSlot> subSlots = this.getSubSlotsFromSubCards(subCards);
        ArrayList pairs = new ArrayList();
        pairs.addAll(this.genSlotBoardPairs(slots, boards));
        pairs.addAll(this.genSubSlotSubCardPairs(subSlots, subCards));
        Collection<FStruct> phyData = this.encode(pairs, (IAsnTranslationContext)context);
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint && !CollectionUtils.isEmpty((Collection)(logicBoards = ((IInventoryUtilExtPoint)interfaceUtilExtPoint).getLogicBoardInfo(req))) && !CollectionUtils.isEmpty(phyData)) {
            HashMap<Integer, LogicBoard> mapLogicBoard = new HashMap<Integer, LogicBoard>();
            for (LogicBoard logicBoard : logicBoards) {
                mapLogicBoard.put(logicBoard.getSlotID(), logicBoard);
            }
            for (Object object : phyData) {
                QAsnNESlotInfo asn = (QAsnNESlotInfo)object;
                if (CollectionUtils.isEmpty((Collection)asn.slotInfoList)) continue;
                for (int index = 0; index < asn.slotInfoList.size(); ++index) {
                    QAsnSlotInfo slot = (QAsnSlotInfo)asn.slotInfoList.get(index);
                    if (!mapLogicBoard.containsKey(slot.slotID)) continue;
                    slot.neLogicCP = this.getBytes(((LogicBoard)mapLogicBoard.get(slot.slotID)).getVendorType());
                }
            }
        }
        return phyData;
    }

    private Collection<SubSlot> getSubSlotsFromSubCards(Collection<SubCard> subCards) {
        ArrayList<SubSlot> subSlots = new ArrayList<SubSlot>();
        for (SubCard subCard : subCards) {
            if (null == subCard) continue;
            SubSlot subSlot = new SubSlot();
            subSlot.setDevID(subCard.getDevID());
            subSlot.setChassisID(subCard.getChassisID());
            subSlot.setSlotID(subCard.getSlotID());
            subSlot.setSubSlotID(subCard.getSubSlotID());
            subSlots.add(subSlot);
        }
        return subSlots;
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnGetSlotInfoRsp rsp) {
        rsp.neSlotInfoList.addAll(queryAsns);
    }

    private Collection<? extends FStruct> encode(List<Pair<?, ?>> moPairs, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(moPairs)) {
            return Collections.emptyList();
        }
        ArrayList<QAsnNESlotInfo> destAsns = new ArrayList<QAsnNESlotInfo>();
        for (Pair<?, ?> moPair : moPairs) {
            QAsnNESlotInfo asn = new QAsnNESlotInfo();
            this.getAsnTranslator().encode(moPair, (FStruct)asn, context);
            QAsnNESlotInfo tmpNeSlotInfo = this.getSameChassisSlotInfos(asn, destAsns);
            if (null == tmpNeSlotInfo) {
                destAsns.add(asn);
                continue;
            }
            tmpNeSlotInfo.slotInfoList.addAll((Collection)asn.slotInfoList);
        }
        return this.sort(destAsns);
    }

    private List<Pair<Slot, Board>> genSlotBoardPairs(Collection<Slot> slots, Collection<Board> boards) {
        if (CollectionUtils.isEmpty(slots)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Slot, Board>> pairs = new ArrayList<Pair<Slot, Board>>();
        for (Slot slot : slots) {
            if (null == slot) continue;
            pairs.add((Pair<Slot, Board>)new Pair((Object)slot, (Object)this.getChild(slot, boards)));
        }
        return pairs;
    }

    private List<Pair<SubSlot, SubCard>> genSubSlotSubCardPairs(Collection<SubSlot> subSlots, Collection<SubCard> subCards) {
        if (CollectionUtils.isEmpty(subSlots)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<SubSlot, SubCard>> pairs = new ArrayList<Pair<SubSlot, SubCard>>();
        for (SubSlot subSlot : subSlots) {
            if (null == subSlot) continue;
            pairs.add((Pair<SubSlot, SubCard>)new Pair((Object)subSlot, (Object)this.getChild(subSlot, subCards)));
        }
        return pairs;
    }

    private Board getChild(Slot slot, Collection<Board> boards) {
        if (CollectionUtils.isEmpty(boards)) {
            return null;
        }
        for (Board board : boards) {
            if (null == board || !ObjectUtils.equals((Object)slot.getDevID(), (Object)board.getDevID()) || !ObjectUtils.equals((Object)slot.getChassisID(), (Object)board.getChassisID()) || !ObjectUtils.equals((Object)slot.getSlotID(), (Object)board.getSlotID())) continue;
            return board;
        }
        return null;
    }

    private SubCard getChild(SubSlot subSlot, Collection<SubCard> subCards) {
        if (CollectionUtils.isEmpty(subCards)) {
            return null;
        }
        for (SubCard subCard : subCards) {
            if (null == subCard || !ObjectUtils.equals((Object)subSlot.getDevID(), (Object)subCard.getDevID()) || !ObjectUtils.equals((Object)subSlot.getChassisID(), (Object)subCard.getChassisID()) || !ObjectUtils.equals((Object)subSlot.getSlotID(), (Object)subCard.getSlotID()) || !ObjectUtils.equals((Object)subSlot.getSubSlotID(), (Object)subCard.getSubSlotID())) continue;
            return subCard;
        }
        return null;
    }

    private QAsnNESlotInfo getSameChassisSlotInfos(QAsnNESlotInfo redundantNeSlotInfo, Collection<QAsnNESlotInfo> neSlotInfos) {
        for (QAsnNESlotInfo neSlotInfo : neSlotInfos) {
            if (neSlotInfo.neID != redundantNeSlotInfo.neID || !neSlotInfo.shelfID.equals(redundantNeSlotInfo.shelfID)) continue;
            return neSlotInfo;
        }
        return null;
    }

    private List<QAsnNESlotInfo> sort(List<QAsnNESlotInfo> originalNeSlots) {
        if (CollectionUtils.isEmpty(originalNeSlots)) {
            return originalNeSlots;
        }
        for (QAsnNESlotInfo originalNeSlot : originalNeSlots) {
            LinkedList<QAsnSlotInfo> sortedOccupySlots = new LinkedList<QAsnSlotInfo>();
            LinkedList<QAsnSlotInfo> sortedUnOccupySlots = new LinkedList<QAsnSlotInfo>();
            for (Object originalSlot : originalNeSlot.slotInfoList) {
                if (QAsnNESlotInfoTranslator.OCCUPY_STATE.equals(((QAsnSlotInfo)originalSlot).occupyState)) {
                    this.sortInsert((QAsnSlotInfo)originalSlot, sortedOccupySlots);
                    continue;
                }
                this.sortInsert((QAsnSlotInfo)originalSlot, sortedUnOccupySlots);
            }
            originalNeSlot.slotInfoList.clear();
            originalNeSlot.slotInfoList.addAll(sortedOccupySlots);
            originalNeSlot.slotInfoList.addAll(sortedUnOccupySlots);
        }
        return originalNeSlots;
    }

    private void sortInsert(QAsnSlotInfo originalSlot, List<QAsnSlotInfo> sortedSlots) {
        int insertIndex = 0;
        for (QAsnSlotInfo sortedSlot : sortedSlots) {
            Integer originalSubSlotID = originalSlot.subSlotID;
            Integer sortedSubSlotID = sortedSlot.subSlotID;
            if (originalSlot.slotID < sortedSlot.slotID || originalSlot.slotID == sortedSlot.slotID && null != originalSubSlotID && originalSubSlotID >= 0 && null != sortedSubSlotID && sortedSubSlotID >= 0 && originalSubSlotID < sortedSubSlotID) break;
            ++insertIndex;
        }
        sortedSlots.add(insertIndex, originalSlot);
    }
}

