/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQQuerySingleMoTypeTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;

public abstract class AbstractQQueryMoTypeWithRuModuleTask<ReqAsnType extends FStruct, RspAsnType extends FStruct, MoType extends PhyEntity>
extends AbstractQQuerySingleMoTypeTask<ReqAsnType, RspAsnType, MoType> {
    protected AbstractQQueryMoTypeWithRuModuleTask(IAsnTranslator asnTranslator) {
        super(asnTranslator);
    }

    protected Collection<?> encode(List<Pair<MoType, RuModuleInfo>> moPairs, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(moPairs)) {
            return Collections.emptyList();
        }
        ArrayList<FStruct> destAsns = new ArrayList<FStruct>();
        for (Pair<MoType, RuModuleInfo> moPair : moPairs) {
            FStruct asn = this.createQueryAsnTypeInstance();
            this.getAsnTranslator().encode(moPair, asn, context);
            destAsns.add(asn);
        }
        return destAsns;
    }

    protected List<Pair<MoType, RuModuleInfo>> genPairs(Collection<MoType> mos, Collection<RuModuleInfo> ruModuleInfos) {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<MoType, RuModuleInfo>> moPairs = new ArrayList<Pair<MoType, RuModuleInfo>>();
        for (PhyEntity mo : mos) {
            if (null == mo) continue;
            moPairs.add(new Pair((Object)mo, null));
        }
        for (RuModuleInfo ruModuleInfo : ruModuleInfos) {
            if (null == ruModuleInfo) continue;
            for (Pair pair : moPairs) {
                if (!ObjectUtils.equals((Object)((PhyEntity)pair.getKey()).getEntIndex(), (Object)ruModuleInfo.getPhyIndex())) continue;
                pair.setValue((Object)ruModuleInfo);
                break;
            }
            this.getLogger().info("ruModule can't find relative mo. ruModuleInfo=" + ruModuleInfo);
        }
        return moPairs;
    }

    protected Collection<?> queryMoInfo(ReqAsnType req, RspAsnType rsp, Task task) throws VMFException {
        ArrayList moIndexes = new ArrayList();
        AsnTranslationContext context = new AsnTranslationContext();
        this.getAsnTranslator().decode(req, moIndexes, (IAsnTranslationContext)context);
        Collection mos = this.queryMoInfos(moIndexes);
        HashSet ruModules = new HashSet();
        for (PhyEntity moType : mos) {
            RuModuleInfo module = new RuModuleInfo();
            module.setDevID(moType.getDevID());
            module.setPhyIndex(moType.getEntIndex());
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection ruModuleInfos = dao.queryByKey(RuModuleInfo.class, ruModules, false);
        return this.encode(this.genPairs(mos, ruModuleInfos), (IAsnTranslationContext)context);
    }
}

