/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.syncdata;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.ifm.translation.asn.serial.IQAsnStmPortTranslatorExtPoint;
import com.huawei.vmf.adapter.extendpoint.inventory.task.IQueryLogicCPInfoTaskExtPoint;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.dao.IRelationMeta;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.syncdata.AbstractFeatureSyncHandler;
import com.huawei.vmf.adapter.framework.translation.schema.FullSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.IncreaseSyncTranslationContext;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevGlobalPara;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.ifm.model.CposPort;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1Port;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.StmPort;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.EntityClass;
import com.huawei.vmf.adapter.fservice.inventory.model.InnerLink;
import com.huawei.vmf.adapter.fservice.inventory.model.LogicBoard;
import com.huawei.vmf.adapter.fservice.inventory.model.LogicPort;
import com.huawei.vmf.adapter.fservice.inventory.model.OpticalInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.ProtectGroup;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.Slot;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.inventory.model.SubSlot;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevmSyncHandler
extends AbstractFeatureSyncHandler {
    private LinkedHashSet<Class<? extends VmfMO>> moClazzes;
    private Logger logger = LoggerFactory.getLogger(DevmSyncHandler.class);

    public DevmSyncHandler() {
        Object stmPortTranslatorExtPoint;
        this.moClazzes = new LinkedHashSet();
        this.moClazzes.add(Chassis.class);
        this.moClazzes.add(Slot.class);
        this.moClazzes.add(Board.class);
        this.moClazzes.add(SubSlot.class);
        this.moClazzes.add(SubCard.class);
        this.moClazzes.add(Port.class);
        this.moClazzes.add(InnerLink.class);
        this.moClazzes.add(RuModuleInfo.class);
        this.moClazzes.add(EntityClass.class);
        Object queryLogicCPInfoTaskExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQueryLogicCPInfoTaskExtPoint.class);
        if (null != queryLogicCPInfoTaskExtPoint) {
            this.moClazzes.add(LogicBoard.class);
            this.moClazzes.add(LogicPort.class);
            this.moClazzes.add(DevGlobalPara.class);
        }
        if (null != (stmPortTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnStmPortTranslatorExtPoint.class))) {
            this.moClazzes.add(EthernetPort.class);
            this.moClazzes.add(ProtectGroup.class);
            this.moClazzes.add(StmPort.class);
        } else {
            this.moClazzes.add(CposPort.class);
            this.moClazzes.add(E1t1Port.class);
        }
    }

    public FeatureName getFeatureName() {
        return FeatureName.DEVM;
    }

    public LinkedHashSet<Class<? extends VmfMO>> getTopMoClasses() {
        return this.moClazzes;
    }

    private <P> void handleSlotId(FullSyncTranslationContext translationContext, Class<P> clazz) throws VMFException {
        IMOChangeRecord changeRecord = translationContext.getContext().getChangeRecord(clazz);
        Map cacheMoMap = translationContext.getContext().getCacheMoMap();
        Map dataFromNe = (Map)cacheMoMap.get(clazz);
        VmfMO mo = null;
        if (null != dataFromNe && !dataFromNe.isEmpty()) {
            mo = (VmfMO)dataFromNe.keySet().iterator().next();
            Integer devId = mo.getDevID();
            ArrayList<Integer> neIDs = new ArrayList<Integer>();
            neIDs.add(devId);
            IDao dao = translationContext.getDao();
            Collection dataFromDb = dao.queryByNeID(clazz, neIDs, false);
            Integer slotIdNe = -1;
            Integer entIndexNe = -1;
            Integer slotIdDb = -1;
            Integer entIndexDb = -1;
            block0: for (Object moNe : dataFromNe.values()) {
                slotIdNe = this.getSlotId(moNe);
                entIndexNe = this.getEntIndex(moNe);
                for (Object moDb : dataFromDb) {
                    slotIdDb = this.getSlotId(moDb);
                    entIndexDb = this.getEntIndex(moDb);
                    if (slotIdNe == -1 || entIndexNe == -1 || slotIdDb == -1 || entIndexDb == -1 || !entIndexNe.equals(entIndexDb) || slotIdNe.equals(slotIdDb)) continue;
                    changeRecord.addDelete(moDb);
                    changeRecord.addCreate(moNe);
                    continue block0;
                }
            }
        }
    }

    private Integer getEntIndex(Object mo) {
        Integer entIndex = -1;
        if (null == mo) {
            return entIndex;
        }
        if (mo instanceof SubCard) {
            SubCard subCard = (SubCard)mo;
            entIndex = subCard.getEntIndex();
        } else if (mo instanceof Port) {
            Port port = (Port)mo;
            entIndex = port.getEntIndex();
        } else if (mo instanceof OpticalInfo) {
            OpticalInfo optical = (OpticalInfo)mo;
            entIndex = optical.getEntIndex();
        } else {
            this.logger.debug("The MO Type didn't match!");
        }
        if (null == entIndex) {
            return -1;
        }
        return entIndex;
    }

    private Integer getSlotId(Object mo) {
        Integer slotId = -1;
        if (null == mo) {
            return slotId;
        }
        if (mo instanceof SubCard) {
            SubCard subCard = (SubCard)mo;
            slotId = subCard.getSlotID();
        } else if (mo instanceof Port) {
            Port port = (Port)mo;
            slotId = port.getSlotID();
        } else if (mo instanceof OpticalInfo) {
            OpticalInfo optical = (OpticalInfo)mo;
            slotId = optical.getSlotID();
        } else {
            this.logger.debug("The MO Type didn't match!");
        }
        if (null == slotId) {
            return -1;
        }
        return slotId;
    }

    protected void fullSyncPreProcess(FullSyncTranslationContext translationContext) throws VMFException {
        super.fullSyncPreProcess(translationContext);
        this.handleSlotId(translationContext, SubCard.class);
        this.handleSlotId(translationContext, Port.class);
        this.handleSlotId(translationContext, OpticalInfo.class);
    }

    protected Collection<?> fullSyncLoadData(IDao dao, Class<?> type, Integer neID) throws VMFException {
        if (type.equals(EntityClass.class)) {
            DevSysInfo devSysInfo = Activator.getDeviceService().getDevSysInfo(neID.intValue());
            if (devSysInfo != null) {
                EntityClass entityClassIndex = new EntityClass();
                entityClassIndex.setDevProductName(devSysInfo.getDevProductName() + devSysInfo.getDevVersionID());
                entityClassIndex.setDevProductVersion(devSysInfo.getDevProductVersion());
                return dao.queryByFields(EntityClass.class, new String[]{"devProductName", "devProductVersion"}, Arrays.asList(entityClassIndex), false);
            }
            return Collections.emptyList();
        }
        return super.fullSyncLoadData(dao, type, neID);
    }

    protected void incrSyncDynamicStatus(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
    }

    protected void incrSyncPreProcess(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
        super.incrSyncPreProcess(incrSyncContext);
        IMOChangeRecord chassisRecord = incrSyncContext.getContext().getChangeRecord(Chassis.class);
        IMOChangeRecord slotRecord = incrSyncContext.getContext().getChangeRecord(Slot.class);
        IMOChangeRecord boardRecord = incrSyncContext.getContext().getChangeRecord(Board.class);
        IMOChangeRecord subSlotRecord = incrSyncContext.getContext().getChangeRecord(SubSlot.class);
        IMOChangeRecord subCardRecord = incrSyncContext.getContext().getChangeRecord(SubCard.class);
        IMOChangeRecord portRecord = incrSyncContext.getContext().getChangeRecord(Port.class);
        IRelationMeta relation = incrSyncContext.getDao().getRelationMeta(Chassis.class);
        for (SubCard subCard : subCardRecord.getDeletes()) {
            this.createCascadeDeleteChild(subCard, Port.class, relation, portRecord);
        }
        for (SubSlot subSlot : subSlotRecord.getDeletes()) {
            this.createCascadeDeleteChild(subSlot, SubCard.class, relation, subCardRecord);
            this.createCascadeDeleteChild(subSlot, Port.class, relation, portRecord);
        }
        for (Board board : boardRecord.getDeletes()) {
            this.createCascadeDeleteChild(board, SubSlot.class, relation, subSlotRecord);
            this.createCascadeDeleteChild(board, SubCard.class, relation, subCardRecord);
            this.createCascadeDeleteChild(board, Port.class, relation, portRecord);
        }
        for (Slot slot : slotRecord.getDeletes()) {
            this.createCascadeDeleteChild(slot, Board.class, relation, boardRecord);
            this.createCascadeDeleteChild(slot, SubSlot.class, relation, subSlotRecord);
            this.createCascadeDeleteChild(slot, SubCard.class, relation, subCardRecord);
            this.createCascadeDeleteChild(slot, Port.class, relation, portRecord);
        }
        for (Chassis chassis : chassisRecord.getDeletes()) {
            this.createCascadeDeleteChild(chassis, Slot.class, relation, slotRecord);
            this.createCascadeDeleteChild(chassis, Board.class, relation, boardRecord);
            this.createCascadeDeleteChild(chassis, SubSlot.class, relation, subSlotRecord);
            this.createCascadeDeleteChild(chassis, SubCard.class, relation, subCardRecord);
            this.createCascadeDeleteChild(chassis, Port.class, relation, portRecord);
        }
    }

    private <T> T createCascadeDeleteChild(Object parent, Class<T> childType, IRelationMeta relation, IMOChangeRecord<T> record) {
        Object child = relation.newInstance(childType);
        relation.setChildKeyByParentKey(parent, child);
        record.addDelete(child);
        return (T)child;
    }
}

