/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.NEUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.common.imap.MessageSessionFactory;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.projectobj.model.ProjectObj;
import com.swimap.imap.common.asn1.common.AsnSendMsgToTrapDllReq;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectObjService {
    public static final int MASTATUS_MAINTAIN = 16;
    public static final int MASTATUS_IN_SERVICE = 0;
    public static final int DSM_TRAP_REOCESS_CMDCODE = 2270;
    public static final int DEFAULT_TIMEOUT = 10;
    private static final char FAULT_PROCESS_ID = '8';
    private static final byte FAULT_PROCESS_TASKMGR = 1;
    private static final String DMS_TRAP_PROCESS_CALLED_DLL = "rsalarmdll.dll";
    private static final String DMS_TRAP_PROCESS_CALLED_SO = "librsalarmdll.so";
    private IDeviceService devService = null;
    private static Logger logger = LoggerFactory.getLogger(ProjectObjService.class);
    private static final Pattern pattern = Pattern.compile("\\d+/\\d+/\\d+");

    public void operate(List<ProjectObj> objList) throws VMFException {
        if (objList == null || objList.isEmpty()) {
            return;
        }
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(ProjectObj.class);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        int operType = objList.get(0).getOperType();
        if (1 == operType) {
            Collection projectExistLst = dao.queryByKey(ProjectObj.class, objList, false);
            if (!projectExistLst.isEmpty()) {
                objList = new LinkedList<ProjectObj>(objList);
                HashSet set = new HashSet(projectExistLst);
                objList.removeAll(set);
            }
            record.addCreate(objList);
        } else if (2 == operType) {
            Collection properties = dao.getPersistentProperties(ProjectObj.class);
            for (ProjectObj projectObj : objList) {
                record.addModify((Object)projectObj, properties);
            }
        } else if (3 == operType) {
            record.addDelete(objList);
        } else {
            return;
        }
        dao.merge(ProjectObj.class, false);
        this.sendMessageToTrapReceiver();
    }

    public void sendMessageToTrapReceiver() throws VMFException {
        AsnSendMsgToTrapDllReq asnReq = new AsnSendMsgToTrapDllReq();
        asnReq.lMsgCmd = BigInteger.valueOf(2270L);
        String cmdDesc = "VMF Notify faultProcess to resfreh projectAlarm";
        asnReq.strCmdDesc = cmdDesc.getBytes();
        String osName = System.getProperty("os.name");
        asnReq.strDllName = osName.toLowerCase().contains("windows") ? DMS_TRAP_PROCESS_CALLED_DLL.getBytes() : DMS_TRAP_PROCESS_CALLED_SO.getBytes();
        int result = MessageSessionFactory.getSession().sendAyncMessage('8', (byte)1, 2270, (FStruct)asnReq);
        if (result != 0) {
            throw new VMFException(result, "send request to fault process fail:" + result);
        }
        logger.error("sendMessageToTrapReceiver Succes :", (Object)asnReq.toString());
    }

    private boolean isNE(ProjectObj obj) {
        String cardDesc = obj.getPoCardDesc();
        String portName = obj.getPortName();
        return !(null != cardDesc && !cardDesc.equals("") || null != portName && !portName.equals(""));
    }

    private boolean isBoard(ProjectObj obj) {
        String cardDesc = obj.getPoCardDesc();
        String portName = obj.getPortName();
        return null != cardDesc && !cardDesc.equals("") && (null == portName || portName.equals(""));
    }

    private void encodeNEFdn(ProjectObj obj) {
        Integer devID = obj.getDevID();
        if (null == devID) {
            return;
        }
        NEUniResIDParser parser = new NEUniResIDParser(devID.intValue());
        obj.setObjIndexFdn(parser.serialize());
    }

    private void encodeBoardFdn(ProjectObj obj) {
        Integer devID = obj.getDevID();
        if (null == devID) {
            return;
        }
        String cardDesc = obj.getPoCardDesc();
        String[] position = cardDesc.split("\\.");
        int frame = Integer.valueOf(position[0]);
        int slotID = Integer.valueOf(position[1]);
        SlotUniResIDParser parser = new SlotUniResIDParser(devID.intValue(), frame, slotID);
        obj.setObjIndexFdn(parser.serialize());
    }

    private void encodePortFdn(ProjectObj obj) {
        String portName = obj.getPortName();
        Matcher matcher = pattern.matcher(portName);
        String position = null;
        if (matcher.find()) {
            position = matcher.group();
            String[] array = position.split("/");
            String slotID = array[0];
            String subSlotID = array[1];
            String portID = array[2];
            PortUniResIDParser parser = new PortUniResIDParser(obj.getDevID().intValue(), obj.getChassisID().intValue(), Integer.valueOf(slotID).intValue(), Integer.valueOf(subSlotID), Integer.valueOf(portID).intValue(), null);
            obj.setObjIndexFdn(parser.serialize());
        }
    }
}

