/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.notify;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.InnerLink;
import com.huawei.vmf.adapter.inventory.notify.AbstractPhyEntityChangeListener;
import com.huawei.vmf.adapter.inventory.translation.asn.AsnEmsIfCreateLinkTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.AsnEmsIfDelLinkTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.AsnTopoStatusInfoTranslator;
import com.swimap.imap.common.asn1.common.AsnEmsIfCreateLinkReq;
import com.swimap.imap.common.asn1.common.AsnEmsIfDelLinkReq;
import com.swimap.imap.common.asn1.common.AsnTopoStatusInfoReq;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class InnerLinkChangeListener
extends AbstractPhyEntityChangeListener<InnerLink> {
    private static final Collection moTypes = Arrays.asList(InnerLink.class);

    public Collection getTrackMoType() {
        return moTypes;
    }

    @Override
    protected void doChange(IMOChangeRecord<InnerLink> moChangeRecord) throws VMFException {
        Collection<InnerLink> innerLinkChangedMOList = this.getChangedMos(moChangeRecord, this.getChangeNotifiedAttributeNames(AsnTopoStatusInfoReq.class));
        List<FStruct> asnEmsIfUpdateLinkAttrReqs = this.encode(AsnTopoStatusInfoReq.class, innerLinkChangedMOList);
        for (FStruct struct : asnEmsIfUpdateLinkAttrReqs) {
            AsnTopoStatusInfoReq innerLinkAsn = (AsnTopoStatusInfoReq)struct;
            this.sendNotification((FStruct)innerLinkAsn, '3', (byte)0, 17);
        }
    }

    @Override
    protected void doCreate(Set<InnerLink> createMos) throws VMFException {
        List<FStruct> asnEmsIfCreateLinkReqs = this.encode(AsnEmsIfCreateLinkReq.class, createMos);
        for (FStruct struct : asnEmsIfCreateLinkReqs) {
            AsnEmsIfCreateLinkReq innerLinkAsn = (AsnEmsIfCreateLinkReq)struct;
            this.sendNotification((FStruct)innerLinkAsn, '3', (byte)0, 12);
        }
    }

    @Override
    protected void doDelete(Set<InnerLink> deleteMos) throws VMFException {
        List<FStruct> innerLinkAsns = this.encode(AsnEmsIfDelLinkReq.class, deleteMos);
        for (FStruct struct : innerLinkAsns) {
            AsnEmsIfDelLinkReq innerLinkAsn = (AsnEmsIfDelLinkReq)struct;
            this.sendNotification((FStruct)innerLinkAsn, '3', (byte)0, 15);
        }
    }

    @Override
    protected void initAsnResReqTranslator() {
    }

    @Override
    protected void initChangeNotifiedAttributeNames() {
        this.addChangeNotifiedAttributeNames(AsnTopoStatusInfoReq.class, "alarmState");
        this.addChangeNotifiedAttributeNames(AsnTopoStatusInfoReq.class, "operStatus");
    }

    @Override
    protected void initTranslators() {
        this.setTranslator(AsnTopoStatusInfoReq.class, (IAsnTranslator)new AsnTopoStatusInfoTranslator());
        this.setTranslator(AsnEmsIfCreateLinkReq.class, (IAsnTranslator)new AsnEmsIfCreateLinkTranslator());
        this.setTranslator(AsnEmsIfDelLinkReq.class, (IAsnTranslator)new AsnEmsIfDelLinkTranslator());
    }
}

