/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.notify;

import com.huawei.network.qasn.m_q_inventory_slot.QAsnCreateSlotRpt;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnDelSlotRpt;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnNESlotInfo;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSlotInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Holder;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.inventory.notify.AbstractPhyEntityChangeListener;
import com.huawei.vmf.adapter.inventory.translation.asn.AsnResReqHolderTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnNESlotInfoTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class HolderChangeListener
extends AbstractPhyEntityChangeListener<Holder> {
    private static final Collection moTypes = Arrays.asList(Holder.class);

    public Collection getTrackMoType() {
        return moTypes;
    }

    @Override
    protected void doChange(IMOChangeRecord<Holder> moChangeRecord) throws VMFException {
    }

    @Override
    protected void doCreate(Set<Holder> createMos) throws VMFException {
        QAsnCreateSlotRpt rpt = new QAsnCreateSlotRpt();
        for (Holder createMo : createMos) {
            this.encodeNeSlotInfo((Collection<QAsnNESlotInfo>)rpt.neSlotInfoList, createMo);
            this.notifyTopoResource(createMo, 1537, '3', (byte)2);
        }
        this.sendNotification((FStruct)rpt, '\u03c0', (byte)0, 2621936);
    }

    @Override
    protected void doDelete(Set<Holder> deleteMos) throws VMFException {
        QAsnDelSlotRpt rpt = new QAsnDelSlotRpt();
        for (Holder deleteMo : deleteMos) {
            this.encodeNeSlotInfo((Collection<QAsnNESlotInfo>)rpt.neSlotInfoList, deleteMo);
            this.notifyTopoResource(deleteMo, 1539, '3', (byte)2);
        }
        this.sendNotification((FStruct)rpt, '\u03c0', (byte)0, 2621937);
    }

    @Override
    protected void initAsnResReqTranslator() {
        this.setAsnResReqTranslator((IAsnTranslator)new AsnResReqHolderTranslator());
    }

    @Override
    protected void initChangeNotifiedAttributeNames() {
    }

    @Override
    protected void initTranslators() {
        this.setTranslator(QAsnSlotInfo.class, (IAsnTranslator)new QAsnNESlotInfoTranslator());
    }

    private void encodeNeSlotInfo(Collection<QAsnNESlotInfo> neSlotAsns, Holder mo) throws VMFException {
        QAsnNESlotInfo neSlotAsn = null;
        try {
            neSlotAsn = this.getNeSlotAsn(neSlotAsns, mo);
        }
        catch (VMFException e) {
            logger.error("get neSlotAsn error.", (Throwable)e);
            return;
        }
        neSlotAsn.slotInfoList.add((Object)this.encode(QAsnSlotInfo.class, (VmfMO)mo, null));
    }

    private QAsnNESlotInfo getNeSlotAsn(Collection<QAsnNESlotInfo> neSlotAsns, Holder holder) throws VMFException {
        Integer devID = holder.getDevID();
        if (null == devID) {
            throw new VMFException(1107498880, "DevID is null. holder=" + holder);
        }
        Integer shelfID = holder.getChassisID();
        for (QAsnNESlotInfo neSlotAsn : neSlotAsns) {
            if (devID != neSlotAsn.neID || !shelfID.equals(neSlotAsn.shelfID)) continue;
            return neSlotAsn;
        }
        QAsnNESlotInfo newNeSlotAsn = new QAsnNESlotInfo();
        newNeSlotAsn.neID = devID;
        newNeSlotAsn.shelfID = shelfID;
        neSlotAsns.add(newNeSlotAsn);
        return newNeSlotAsn;
    }
}

