/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.notify;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQAsnAggrPortMemberTaskExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.Lag;
import com.huawei.vmf.adapter.fservice.ifm.model.LagMemberIf;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.InnerLink;
import com.huawei.vmf.adapter.fservice.inventory.model.OpticalInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.ProtectGroup;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.Slot;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.inventory.model.SubSlot;
import com.huawei.vmf.adapter.inventory.notify.AbstractPhyEntityChangeListener;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import com.swimap.imap.common.asn1.common.AsnSeviceState;
import com.swimap.imap.common.asn1.common.AsnTopoStatus;
import com.swimap.imap.common.asn1.common.AsnTopoStatusInfo;
import com.swimap.imap.common.asn1.common.AsnTopoStatusInfoReq;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class DeviceStatusChangeListener
extends AbstractPhyEntityChangeListener<DevSysInfo> {
    private static final Collection moTypes = Arrays.asList(DevSysInfo.class);

    public Collection getTrackMoType() {
        return moTypes;
    }

    @Override
    protected void doChange(IMOChangeRecord<DevSysInfo> moChangeRecord) throws VMFException {
        try {
            Collection operStatusChanges = moChangeRecord.getPropertyChangedMO(new String[]{"operStatus"});
            for (DevSysInfo devSysInfo : operStatusChanges) {
                if (devSysInfo.getDevVersionID() == null || 2 != devSysInfo.getDevVersionID() && 3 != devSysInfo.getDevVersionID()) continue;
                this.refreshTopoInnerLink(devSysInfo, devSysInfo.getOperStatus());
            }
        }
        catch (Exception e) {
            logger.error("refresh inner link status failed.", (Throwable)e);
        }
    }

    @Override
    protected void doCreate(Set<DevSysInfo> createMos) throws VMFException {
    }

    @Override
    protected void doDelete(Set<DevSysInfo> deleteMos) throws VMFException {
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        for (DevSysInfo devSysInfo : deleteMos) {
            this.prepareDeletion(ctx, devSysInfo.getDevID());
        }
        this.notifyDeleteChassisInfo(deleteMos);
        this.notifyDeleteBoardInfo(deleteMos);
        this.notifyDeleteSubCardInfo(deleteMos);
        Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnAggrPortMemberTaskExtPoint.class);
        if (null != extPoint) {
            dao.merge(false, new Class[]{Chassis.class, Slot.class, SubSlot.class, SubCard.class, Port.class, InnerLink.class, RuModuleInfo.class, Lag.class, LagMemberIf.class, EthernetPort.class, OpticalInfo.class, ProtectGroup.class});
        } else {
            dao.merge(false, new Class[]{Chassis.class, Slot.class, SubSlot.class, SubCard.class, Port.class, InnerLink.class, RuModuleInfo.class});
        }
    }

    @Override
    protected void initAsnResReqTranslator() {
    }

    @Override
    protected void initChangeNotifiedAttributeNames() {
    }

    @Override
    protected void initTranslators() {
    }

    protected Collection<Board> queryBoardInfos(int devID) {
        Board boardMo = new Board();
        boardMo.setDevID(Integer.valueOf(devID));
        ArrayList<Board> boardMos = new ArrayList<Board>();
        boardMos.add(boardMo);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> boardClazz = ((Board)boardMos.iterator().next()).getClass();
        Collection boardResult = null;
        try {
            boardResult = dao.queryByKey(boardClazz, boardMos, false);
        }
        catch (VMFException e) {
            logger.debug("DeviceStatusChangeListener queryBoardInfos for Board to fail: " + (Object)((Object)e));
        }
        return boardResult;
    }

    protected Collection<Chassis> queryChassisInfos(int devID) {
        Chassis chassisMo = new Chassis();
        chassisMo.setDevID(Integer.valueOf(devID));
        ArrayList<Chassis> chassisMos = new ArrayList<Chassis>();
        chassisMos.add(chassisMo);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> chassisClazz = ((Chassis)chassisMos.iterator().next()).getClass();
        Collection chassisResult = null;
        try {
            chassisResult = dao.queryByKey(chassisClazz, chassisMos, false);
        }
        catch (VMFException e) {
            logger.debug("DeviceStatusChangeListener queryChassisInfos for Chassis to fail: " + (Object)((Object)e));
        }
        return chassisResult;
    }

    protected Collection<SubCard> querySubCardInfos(int devID) {
        SubCard subCardMo = new SubCard();
        subCardMo.setDevID(Integer.valueOf(devID));
        ArrayList<SubCard> subCardMos = new ArrayList<SubCard>();
        subCardMos.add(subCardMo);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> subCardClazz = ((SubCard)subCardMos.iterator().next()).getClass();
        Collection subCardResult = null;
        try {
            subCardResult = dao.queryByKey(subCardClazz, subCardMos, false);
        }
        catch (VMFException e) {
            logger.debug("DeviceStatusChangeListener querySubCardInfos for SubCard to fail: " + (Object)((Object)e));
        }
        return subCardResult;
    }

    private void notifyDeleteBoardInfo(Set<DevSysInfo> deleteMos) throws VMFException {
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        for (DevSysInfo devSysInfo : deleteMos) {
            Collection<Board> boardMos = this.queryBoardInfos(devSysInfo.getDevID());
            if (CollectionUtils.isEmpty(boardMos)) continue;
            ctx.addChangeRecord(Board.class).addDelete(boardMos);
        }
        MOChangePublisher.getInstance().notifyChanges(ctx);
        dao.merge(false, new Class[]{Board.class});
    }

    private void notifyDeleteChassisInfo(Set<DevSysInfo> deleteMos) throws VMFException {
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        for (DevSysInfo devSysInfo : deleteMos) {
            Collection<Chassis> chassisMos = this.queryChassisInfos(devSysInfo.getDevID());
            if (CollectionUtils.isEmpty(chassisMos)) continue;
            ctx.addChangeRecord(Chassis.class).addDelete(chassisMos);
        }
        MOChangePublisher.getInstance().notifyChanges(ctx);
        dao.merge(false, new Class[]{Chassis.class});
    }

    private void notifyDeleteSubCardInfo(Set<DevSysInfo> deleteMos) throws VMFException {
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        for (DevSysInfo devSysInfo : deleteMos) {
            Collection<SubCard> subCardMos = this.querySubCardInfos(devSysInfo.getDevID());
            if (CollectionUtils.isEmpty(subCardMos)) continue;
            ctx.addChangeRecord(SubCard.class).addDelete(subCardMos);
        }
        MOChangePublisher.getInstance().notifyChanges(ctx);
        dao.merge(false, new Class[]{SubCard.class});
    }

    private void prepareDeletion(Context ctx, int neID) {
        Slot slot = new Slot();
        slot.setDevID(Integer.valueOf(neID));
        ctx.addChangeRecord(Slot.class).addDelete((Object)slot);
        SubSlot subSlot = new SubSlot();
        subSlot.setDevID(Integer.valueOf(neID));
        ctx.addChangeRecord(SubSlot.class).addDelete((Object)subSlot);
        Object extPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnAggrPortMemberTaskExtPoint.class);
        if (null != extPoint) {
            Lag lag = new Lag();
            lag.setDevID(Integer.valueOf(neID));
            ctx.addChangeRecord(Lag.class).addDelete((Object)lag);
            LagMemberIf lagMember = new LagMemberIf();
            lagMember.setDevID(Integer.valueOf(neID));
            ctx.addChangeRecord(LagMemberIf.class).addDelete((Object)lagMember);
            EthernetPort ethPort = new EthernetPort();
            ethPort.setDevID(Integer.valueOf(neID));
            ctx.addChangeRecord(EthernetPort.class).addDelete((Object)ethPort);
            OpticalInfo op = new OpticalInfo();
            op.setDevID(Integer.valueOf(neID));
            ctx.addChangeRecord(OpticalInfo.class).addDelete((Object)op);
            ProtectGroup prog = new ProtectGroup();
            prog.setDevID(Integer.valueOf(neID));
            ctx.addChangeRecord(ProtectGroup.class).addDelete((Object)prog);
        }
        Port port = new Port();
        port.setDevID(Integer.valueOf(neID));
        ctx.addChangeRecord(Port.class).addDelete((Object)port);
        InnerLink innerLink = new InnerLink();
        innerLink.setDevID(Integer.valueOf(neID));
        ctx.addChangeRecord(InnerLink.class).addDelete((Object)innerLink);
        RuModuleInfo ruModule = new RuModuleInfo();
        ruModule.setDevID(Integer.valueOf(neID));
        ctx.addChangeRecord(RuModuleInfo.class).addDelete((Object)ruModule);
    }

    private void refreshTopoInnerLink(DevSysInfo dev, int newState) throws VMFException {
        if (1 != newState && 3 != newState) {
            logger.debug("device status {} is not online or offline, inner link status will not be refreshed.", (Object)newState);
            return;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection innerLinks = dao.queryByNeID(InnerLink.class, Arrays.asList(dev.getDevID()), false);
        for (InnerLink innerLink : innerLinks) {
            AsnTopoStatusInfoReq updateLinkReq = new AsnTopoStatusInfoReq();
            AsnTopoStatusInfo topoStatusInfo = new AsnTopoStatusInfo();
            updateLinkReq.add((Object)topoStatusInfo);
            topoStatusInfo.strObjID = StringUtil.globalByte((String)innerLink.getInnerLinkDN());
            AsnTopoStatus oStatus = new AsnTopoStatus();
            AsnSeviceState state = new AsnSeviceState();
            state.iPos = BigInteger.ZERO;
            state.iStatus = BigInteger.valueOf(newState);
            state.iStatusMask = BigInteger.ZERO;
            oStatus.add((Object)state);
            topoStatusInfo.oStatus = oStatus;
            this.sendNotification((FStruct)updateLinkReq, '3', (byte)0, 17);
        }
    }
}

