/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.notify;

import com.huawei.network.qasn.m_q_inventory_shelf.QAsnCreateShelfRpt;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnDelShelfRpt;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfChgRpt;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FrameUniResIDParser;
import com.huawei.vmf.adapter.common.imap.MdpSessionImpl;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.devicemgr.service.ILicenseService;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.notify.AbstractPhyEntityChangeListener;
import com.huawei.vmf.adapter.inventory.translation.asn.AsnResReqChassisTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.FInventoryAsnHelper;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnShelfInfoTranslator;
import com.swimap.imap.common.asn1.common.AsnDistinguishedResource;
import com.swimap.imap.common.asn1.common.AsnEmsIfCreateDevReq;
import com.swimap.imap.common.asn1.common.AsnEmsIfDelNodeReq;
import com.swimap.imap.common.asn1.common.AsnTopoRespMsg;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class ChassisChangeListener
extends AbstractPhyEntityChangeListener<Chassis> {
    private static final Collection moTypes = Arrays.asList(Chassis.class);
    private static final int SUCCESS = 0;

    public Collection getTrackMoType() {
        return moTypes;
    }

    public int notifyTopoAddFrameNode(Set<Chassis> chassiss) {
        try {
            if (chassiss.isEmpty()) {
                return 0;
            }
            int devID = chassiss.iterator().next().getDevID();
            AsnTopoRespMsg resp = new AsnTopoRespMsg();
            MdpSessionImpl session = new MdpSessionImpl();
            AsnEmsIfCreateDevReq asn = FInventoryAsnHelper.getAddFrameAsn(devID, chassiss);
            int ret = session.sendSyncMessage('3', (byte)0, 10, (FStruct)asn, (FStruct)resp);
            if (0 == ret) {
                ret = resp.iReturnCode.intValue();
            }
            logger.info("notify topo add frame node ret= " + ret);
            return ret;
        }
        catch (VMFException e) {
            logger.error("notify topo add frame node failed " + (Object)((Object)e));
            return e.getErrorCode();
        }
    }

    public void notifyTopoDelFrameNode(Set<Chassis> chassiss) {
        for (Chassis chassis : chassiss) {
            FrameUniResIDParser parser = new FrameUniResIDParser(chassis.getDevID().intValue(), chassis.getParentRelPosition().intValue());
            String fdn = parser.serialize();
            AsnTopoRespMsg resp = new AsnTopoRespMsg();
            MdpSessionImpl session = new MdpSessionImpl();
            AsnEmsIfDelNodeReq asn = this.setTopoResourceAsn(fdn, 3, chassis.getChassisType(), chassis.getDescription());
            int ret = session.sendSyncMessage('3', (byte)0, 14, (FStruct)asn, (FStruct)resp);
            if (0 != ret) continue;
            logger.info("notify topo delete frame node. chassis name = " + chassis.getName());
        }
    }

    @Override
    protected void doChange(IMOChangeRecord<Chassis> moChangeRecord) throws VMFException {
        List<Chassis> portInfoChgMos = this.getModifyMos(moChangeRecord);
        QAsnShelfChgRpt rpt = new QAsnShelfChgRpt();
        rpt.shelfInfoList.addAll(this.encode(QAsnShelfInfo.class, portInfoChgMos));
        if (!CollectionUtils.isEmpty((Collection)rpt.shelfInfoList)) {
            this.sendNotification((FStruct)rpt, '\u0400', (byte)0, 65553);
        }
    }

    @Override
    protected void doCreate(Set<Chassis> createMos) throws VMFException {
        if (createMos == null || createMos.size() == 0) {
            return;
        }
        int lcsNum = 0;
        int devID = 0;
        IAsnTranslationContext context = this.createTranslationContext(createMos);
        for (Chassis createMo : createMos) {
            devID = createMo.getDevID();
            QAsnCreateShelfRpt rpt = new QAsnCreateShelfRpt();
            rpt.shelfInfoList.add((Object)this.encode(QAsnShelfInfo.class, (VmfMO)createMo, context));
            this.sendReliableEvent(65551, (FStruct)rpt);
            this.notifyTopoResource(createMo, 1537, '3', (byte)2);
            if (!this.isMultiFrameDevice(devID) || createMo.getSvcType() == null || !Integer.valueOf(Chassis.SERVICE_TYPE_ENUM.LINE_CHASSIS).equals(createMo.getSvcType())) continue;
            ++lcsNum;
        }
        if (this.isMultiFrameDevice(devID)) {
            this.notifyTopoAddFrameNode(createMos);
        }
        if (lcsNum > 0) {
            this.changeLicense(devID, lcsNum, true);
        }
    }

    @Override
    protected void doDelete(Set<Chassis> deleteMos) throws VMFException {
        int lcsNum = 0;
        int devID = 0;
        for (Chassis deleteMo : deleteMos) {
            QAsnDelShelfRpt rpt = new QAsnDelShelfRpt();
            rpt.shelfInfoList.add((Object)this.encode(QAsnShelfInfo.class, (VmfMO)deleteMo, null));
            this.sendReliableEvent(65552, (FStruct)rpt);
            devID = deleteMo.getDevID();
            if (!this.isMultiFrameDevice(devID) || deleteMo.getSvcType() == null || !Integer.valueOf(Chassis.SERVICE_TYPE_ENUM.LINE_CHASSIS).equals(deleteMo.getSvcType())) continue;
            ++lcsNum;
        }
        if (this.isMultiFrameDevice(devID)) {
            this.notifyTopoDelFrameNode(deleteMos);
        }
        if (!deleteMos.isEmpty() && lcsNum < 0) {
            this.changeLicense(devID, lcsNum, false);
        }
    }

    @Override
    protected void initAsnResReqTranslator() {
        this.setAsnResReqTranslator((IAsnTranslator)new AsnResReqChassisTranslator());
    }

    @Override
    protected void initChangeNotifiedAttributeNames() {
    }

    @Override
    protected void initTranslators() {
        this.setTranslator(QAsnShelfInfo.class, (IAsnTranslator)new QAsnShelfInfoTranslator());
    }

    private void changeLicense(int devID, int number, boolean apply) {
        try {
            ILicenseService licenseSrv = (ILicenseService)Activator.getService(ILicenseService.class);
            int ret = 0;
            ret = apply ? licenseSrv.applyLicense(devID, number) : licenseSrv.releaseLicense(devID, number);
            logger.info("change license of device={}, result={}", new Object[]{devID, ret});
        }
        catch (VMFException e) {
            logger.error("changeLicense.", (Throwable)e);
        }
    }

    private boolean isMultiFrameDevice(int devID) {
        try {
            IDeviceService deviceSrv = Activator.getDeviceService();
            return deviceSrv.isMultiChassisDevice(devID);
        }
        catch (VMFException e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }

    private AsnEmsIfDelNodeReq setTopoResourceAsn(String fdn, int maintype, int subtype, String lable) {
        AsnEmsIfDelNodeReq newResAsnObj = new AsnEmsIfDelNodeReq();
        AsnDistinguishedResource oTarget = new AsnDistinguishedResource();
        oTarget.resDN = fdn.getBytes();
        oTarget.maintype = BigInteger.valueOf(maintype);
        oTarget.subtype = BigInteger.valueOf(subtype);
        oTarget.label = lable == null ? "".getBytes() : lable.getBytes();
        newResAsnObj.oResIDList = oTarget;
        return newResAsnObj;
    }
}

