/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.notify;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnBatchDelCPRpt;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfoChgRpt;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPState;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPStateChgRpt;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCreateCPRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnMibIndexChangedRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnResAttrChangeRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnResMibIndexPair;
import com.huawei.network.qasn.q_pms_base.QAsnResAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.dao.RuModuleInfoDao;
import com.huawei.vmf.adapter.inventory.notify.AbstractPhyEntityChangeListener;
import com.huawei.vmf.adapter.inventory.translation.asn.AsnResReqCardTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.PhyEntityAsnTranslationContextWithRuModule;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCPInfoTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCPStateTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCardResAttrTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCardResMibIndexTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCardUniResIDTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class CardChangeListener<MOType extends Card>
extends AbstractPhyEntityChangeListener<MOType> {
    private static final Collection moTypes = Arrays.asList(Board.class, SubCard.class);

    public Collection getTrackMoType() {
        return moTypes;
    }

    @Override
    protected IAsnTranslationContext createTranslationContext(Collection<MOType> cards) throws VMFException {
        RuModuleInfoDao dao = (RuModuleInfoDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, RuModuleInfoDao.class);
        Map<MOType, RuModuleInfo> map = dao.queryRuModuleMap(cards);
        return new PhyEntityAsnTranslationContextWithRuModule(map);
    }

    @Override
    protected void doChange(IMOChangeRecord<MOType> moChangeRecord) throws VMFException {
        Collection<MOType> cpStateChgMos = this.getChangedMos(moChangeRecord, this.getChangeNotifiedAttributeNames(QAsnCPStateChgRpt.class));
        QAsnCPStateChgRpt cpStateChgRpt = new QAsnCPStateChgRpt();
        cpStateChgRpt.cpStateList.addAll(this.encode(QAsnCPState.class, cpStateChgMos));
        this.sendNotification((FStruct)cpStateChgRpt, '\u03c0', (byte)0, 65555);
        List<MOType> cpInfoChgMos = this.getModifyMos(moChangeRecord);
        cpInfoChgMos.removeAll(cpStateChgMos);
        QAsnCPInfoChgRpt cpInfoChgRpt = new QAsnCPInfoChgRpt();
        cpInfoChgRpt.cpInfoList.addAll(this.encode(QAsnCPInfo.class, cpInfoChgMos));
        this.sendReliableEvent(2191374, (FStruct)cpInfoChgRpt);
        this.notifyTopoResources(this.getModifyMos(moChangeRecord), 1541, '3', (byte)2);
        this.notifyIndexChangedToPms(moChangeRecord);
        this.notifyNameChangeToPms(moChangeRecord);
    }

    @Override
    protected void doCreate(Set<MOType> createMos) throws VMFException {
        QAsnCreateCPRpt rpt = new QAsnCreateCPRpt();
        AsnUtil.setDefaultAsnValue((FStruct)rpt);
        List<FStruct> list = this.encode(QAsnCPInfo.class, createMos);
        if (!CollectionUtils.isEmpty(list)) {
            for (FStruct data : list) {
                QAsnCPInfo op = (QAsnCPInfo)data;
                rpt.cpInfoList.add((Object)op);
            }
        }
        this.sendReliableEvent(2191372, (FStruct)rpt);
        this.notifyTopoResources(createMos, 1537, '3', (byte)2);
    }

    @Override
    protected void doDelete(Set<MOType> deleteMos) throws VMFException {
        QAsnBatchDelCPRpt rpt = new QAsnBatchDelCPRpt();
        List<FStruct> asnCpInfos = this.encode(QAsnCPInfo.class, deleteMos);
        for (FStruct asnCpInfo : asnCpInfos) {
            rpt.cpIndexList.add((Object)((QAsnCPInfo)asnCpInfo).cpIndex);
        }
        this.sendReliableEvent(2191373, (FStruct)rpt);
        this.notifyTopoResources(deleteMos, 1539, '3', (byte)2);
        this.notifyResDelToPms(deleteMos);
    }

    @Override
    protected void initAsnResReqTranslator() {
        this.setAsnResReqTranslator((IAsnTranslator)new AsnResReqCardTranslator());
    }

    @Override
    protected void initChangeNotifiedAttributeNames() {
        this.addChangeNotifiedAttributeNames(QAsnCPStateChgRpt.class, "adminStatus");
        this.addChangeNotifiedAttributeNames(QAsnCPStateChgRpt.class, "operStatus");
        this.addChangeNotifiedAttributeNames(QAsnMibIndexChangedRpt.class, "entIndex");
        this.addChangeNotifiedAttributeNames(QAsnResAttrChangeRpt.class, "name");
    }

    @Override
    protected void initTranslators() {
        this.setTranslator(QAsnCPState.class, (IAsnTranslator)new QAsnCPStateTranslator());
        this.setTranslator(QAsnCPInfo.class, (IAsnTranslator)new QAsnCPInfoTranslator());
        this.setTranslator(QAsnResMibIndexPair.class, (IAsnTranslator)new QAsnCardResMibIndexTranslator());
        this.setTranslator(QAsnResAttr.class, (IAsnTranslator)new QAsnCardResAttrTranslator());
        this.setTranslator(QAsnUniResID.class, (IAsnTranslator)new QAsnCardUniResIDTranslator());
    }
}

