/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.notify;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnBatchMibindexChangeRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnMibIndexChangedRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnMibindexChangeRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnResAttrChangeRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnResDeleteRpt;
import com.huawei.network.qasn.m_q_pms_reschg.QAsnResMibIndexPair;
import com.huawei.network.qasn.q_pms_base.QAsnResAttr;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.exception.AsnTransformException;
import com.huawei.vmf.adapter.framework.notify.AbstractMOChangeListener;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.swimap.imap.common.asn1.common.AsnResourceBatchReq;
import com.swimap.imap.common.asn1.common.AsnResourceReq;
import com.swimap.imap.common.asn1.common.AsnResourceTreeReq;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractPhyEntityChangeListener<MoType extends VmfMO>
extends AbstractMOChangeListener {
    private IAsnTranslator asnResReqTranslator;
    private Map<Class<? extends FStruct>, Set<String>> changeNotifiedAttributeNames = new HashMap<Class<? extends FStruct>, Set<String>>();
    private Map<Class<? extends FStruct>, IAsnTranslator> translators = new HashMap<Class<? extends FStruct>, IAsnTranslator>();

    protected AbstractPhyEntityChangeListener() {
        this.initTranslators();
        this.initAsnResReqTranslator();
        this.initChangeNotifiedAttributeNames();
    }

    public void handleChanges(Context context) throws VMFException {
        for (Object type : this.getTrackMoType()) {
            IMOChangeRecord record = context.getChangeRecord((Class)type);
            this.handleEvent(record);
        }
    }

    public void handleEvent(IMOChangeRecord<MoType> moChangeRecord) {
        logger.info("start handle mo change. moClass=" + moChangeRecord.getClass());
        Set createMos = moChangeRecord.getCreates();
        Set deleteMos = moChangeRecord.getDeletes();
        try {
            if (!CollectionUtils.isEmpty((Collection)moChangeRecord.getModifies())) {
                this.doChange(moChangeRecord);
            }
        }
        catch (VMFException e) {
            logger.error("notify change report error. modifyMoInfoMap=" + moChangeRecord, (Throwable)e);
        }
        try {
            if (!CollectionUtils.isEmpty((Collection)createMos)) {
                this.doCreate(createMos);
            }
        }
        catch (VMFException e) {
            logger.error("notify create report error. createMos=" + createMos, (Throwable)e);
        }
        try {
            if (!CollectionUtils.isEmpty((Collection)deleteMos)) {
                this.doDelete(deleteMos);
            }
        }
        catch (VMFException e) {
            logger.error("notify delete report error. deleteMos=" + deleteMos, (Throwable)e);
        }
        logger.info("end handle mo change. moClass=" + moChangeRecord.getClass());
    }

    protected void addChangeNotifiedAttributeNames(Class<? extends FStruct> notifyAsnClazz, String attributeName) {
        Set<String> attributeNames = this.changeNotifiedAttributeNames.get(notifyAsnClazz);
        if (null == attributeNames) {
            attributeNames = new HashSet<String>();
            this.changeNotifiedAttributeNames.put(notifyAsnClazz, attributeNames);
        }
        attributeNames.add(attributeName);
    }

    protected abstract void doChange(IMOChangeRecord<MoType> var1) throws VMFException;

    protected abstract void doCreate(Set<MoType> var1) throws VMFException;

    protected abstract void doDelete(Set<MoType> var1) throws VMFException;

    protected List<FStruct> encode(Class<? extends FStruct> asnClazz, Collection<MoType> mos) {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyList();
        }
        ArrayList<FStruct> asns = new ArrayList<FStruct>();
        try {
            IAsnTranslationContext context = this.createTranslationContext(mos);
            for (VmfMO mo : mos) {
                if (null == mo) continue;
                asns.add(this.encode(asnClazz, mo, context));
            }
        }
        catch (VMFException e) {
            logger.error("Encode mo to asn error. asnClazz=" + asnClazz.getName() + ", mo=" + mos, (Throwable)e);
        }
        return asns;
    }

    protected IAsnTranslationContext createTranslationContext(Collection<MoType> mos) throws VMFException {
        return new AsnTranslationContext();
    }

    protected FStruct encode(Class<? extends FStruct> asnClazz, VmfMO mo, IAsnTranslationContext context) throws VMFException {
        IAsnTranslator asnTranslator = this.translators.get(asnClazz);
        if (null == asnTranslator) {
            throw new VMFException(1107498880, "Can not get translator. asnClazz=" + asnClazz.getName());
        }
        try {
            FStruct asn = asnClazz.newInstance();
            asnTranslator.encode((Object)mo, asn, context);
            return asn;
        }
        catch (InstantiationException e) {
            throw new AsnTransformException("Create ASN Object error. ASNType=" + asnClazz.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AsnTransformException("Create ASN Object error. ASNType=" + asnClazz.getName(), (Throwable)e);
        }
    }

    protected IAsnTranslator getAsnResReqTranslator() throws VMFException {
        if (null == this.asnResReqTranslator) {
            throw new VMFException(1107498880, "asnResReqTranslator is null.");
        }
        return this.asnResReqTranslator;
    }

    protected Collection<MoType> getChangedMos(IMOChangeRecord<MoType> moChangeRecord, String ... attributeNames) {
        return moChangeRecord.getPropertyChangedMO(attributeNames);
    }

    protected String[] getChangeNotifiedAttributeNames(Class<? extends FStruct> notifyAsnClazz) {
        Set<String> attributes = this.changeNotifiedAttributeNames.get(notifyAsnClazz);
        return attributes.toArray(new String[attributes.size()]);
    }

    protected List<MoType> getModifyMos(IMOChangeRecord<MoType> moChangeRecord) {
        return new ArrayList(moChangeRecord.getModifies());
    }

    protected abstract void initAsnResReqTranslator();

    protected abstract void initChangeNotifiedAttributeNames();

    protected abstract void initTranslators();

    protected void notifyBatchMibindexChangeToPms(int neID, int typeID) {
        QAsnBatchMibindexChangeRpt batMibIndChgrpt = new QAsnBatchMibindexChangeRpt();
        batMibIndChgrpt.neID = neID;
        batMibIndChgrpt.neTypeID = BigInteger.valueOf(typeID);
        this.sendNotification((FStruct)batMibIndChgrpt, '\u0bc2', (byte)2, 31537);
    }

    protected void notifyIndexChangedToPms(IMOChangeRecord<MoType> moChangeRecord) {
        QAsnMibIndexChangedRpt mibIndexChgRpt = new QAsnMibIndexChangedRpt();
        Collection<MoType> indexChgMos = this.getChangedMos(moChangeRecord, this.getChangeNotifiedAttributeNames(QAsnMibIndexChangedRpt.class));
        if (null != indexChgMos && !indexChgMos.isEmpty()) {
            mibIndexChgRpt.changedResMibIndexPairList.addAll(this.encode(QAsnResMibIndexPair.class, indexChgMos));
            this.sendNotification((FStruct)mibIndexChgRpt, '\u0bc2', (byte)2, 65545);
        }
    }

    protected void notifyMibindexChangeToPms(MoType motype) {
        QAsnMibindexChangeRpt mibIndexChgRpt = new QAsnMibindexChangeRpt();
        PhyEntity entity = (PhyEntity)motype;
        mibIndexChgRpt.mibIndex = String.valueOf(entity.getEntIndex()).getBytes();
        mibIndexChgRpt.neID = entity.getDevID();
        mibIndexChgRpt.resID = new QAsnUniResID();
        this.sendNotification((FStruct)mibIndexChgRpt, '\u0bc2', (byte)2, 31536);
    }

    protected void notifyNameChangeToPms(IMOChangeRecord<MoType> moChangeRecord) {
        QAsnResAttrChangeRpt resAttrChgRpt = new QAsnResAttrChangeRpt();
        Collection<MoType> nameChgMos = this.getChangedMos(moChangeRecord, this.getChangeNotifiedAttributeNames(QAsnResAttrChangeRpt.class));
        if (null != nameChgMos && !nameChgMos.isEmpty()) {
            resAttrChgRpt.changedResAttrList.addAll(this.encode(QAsnResAttr.class, nameChgMos));
            this.sendNotification((FStruct)resAttrChgRpt, '\u0bc2', (byte)2, 65549);
        }
    }

    protected void notifyResDelToPms(Collection<MoType> deleteMos) {
        QAsnResDeleteRpt resDelRpt = new QAsnResDeleteRpt();
        resDelRpt.deletedResIDList.addAll(this.encode(QAsnUniResID.class, deleteMos));
        this.sendNotification((FStruct)resDelRpt, '\u0bc2', (byte)2, 65546);
    }

    protected void notifyTopoResource(MoType mo, int cmdID, char receiverProcID, byte receiverModule) throws VMFException {
        AsnResourceTreeReq oDelResObj = new AsnResourceTreeReq();
        AsnResourceBatchReq oResBatchObj = new AsnResourceBatchReq();
        oResBatchObj.delResList = oDelResObj;
        oResBatchObj.iSyncAlm = BigInteger.valueOf(0L);
        AsnResourceReq resAsnObj = new AsnResourceReq();
        this.getAsnResReqTranslator().encode(mo, (FStruct)resAsnObj, null);
        oResBatchObj.delResList.add((Object)resAsnObj);
        if (mo instanceof Board) {
            this.sendNotification((FStruct)oResBatchObj, receiverProcID, receiverModule, cmdID);
            resAsnObj.res.maintype = BigInteger.valueOf(20L);
            String fdn = StringUtil.globalString((byte[])resAsnObj.res.resDN) + ",CP=-1";
            resAsnObj.res.resDN = StringUtil.globalByte((String)fdn);
            this.sendNotification((FStruct)oResBatchObj, receiverProcID, receiverModule, cmdID);
            return;
        }
        if (mo instanceof SubCard) {
            this.sendNotification((FStruct)oResBatchObj, receiverProcID, receiverModule, cmdID);
            resAsnObj.res.maintype = BigInteger.valueOf(21L);
            String fdn = StringUtil.globalString((byte[])resAsnObj.res.resDN) + ",SC=-1";
            resAsnObj.res.resDN = StringUtil.globalByte((String)fdn);
            this.sendNotification((FStruct)oResBatchObj, receiverProcID, receiverModule, cmdID);
            return;
        }
        this.sendNotification((FStruct)oResBatchObj, receiverProcID, receiverModule, cmdID);
    }

    protected void notifyTopoResources(Collection<MoType> mos, int cmdID, char receiverProcID, byte receiverModule) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        for (VmfMO mo : mos) {
            try {
                this.notifyTopoResource(mo, cmdID, receiverProcID, receiverModule);
            }
            catch (VMFException e) {
                logger.error("Send topo notification error. mo=" + mo + ", cmdID=" + cmdID + ", receiverProcID=" + receiverProcID + ", receiverModule=" + receiverModule, (Throwable)e);
            }
        }
    }

    protected void setAsnResReqTranslator(IAsnTranslator asnResReqTranslator) {
        this.asnResReqTranslator = asnResReqTranslator;
    }

    protected void setTranslator(Class<? extends FStruct> asnClazz, IAsnTranslator translator) {
        this.translators.put(asnClazz, translator);
    }
}

