/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.netconf;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortQuery {
    private static final Logger logger = LoggerFactory.getLogger(PortQuery.class);

    public static List<Port> query(int devID, int boardIndex) {
        Port mo = new Port();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        mo.setBoardID(Integer.valueOf(boardIndex));
        INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID);
        try {
            QuerySchemaTranslatorContext context = new QuerySchemaTranslatorContext(devID);
            context.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus", "standbyStatus", "adminStatus"));
            netconfPoller.query(context);
            return (List)context.getQueryResult(Port.class);
        }
        catch (VMFException e) {
            logger.error("query subcard from device failed!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static Port query(int devID, String entClass, String position) {
        Port mo = new Port();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        mo.setEntityClass(entClass);
        mo.setEntPosition(position);
        INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID);
        try {
            QuerySchemaTranslatorContext context = new QuerySchemaTranslatorContext(devID);
            context.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus", "standbyStatus", "adminStatus"));
            netconfPoller.query(context);
            Collection ports = context.getQueryResult(Port.class);
            mo = null == ports || ports.isEmpty() ? null : (Port)ports.iterator().next();
            return mo;
        }
        catch (VMFException e) {
            logger.error("query subcard from device failed!", (Throwable)e);
            return null;
        }
    }
}

