/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.netconf;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhyEntityQuery {
    private static final Logger logger = LoggerFactory.getLogger(PhyEntityQuery.class);

    public static void query(int devID, int chassisIndex, List<Board> boards, List<SubCard> subCards, List<Port> ports) {
        if (null == boards || null == subCards || null == ports) {
            return;
        }
        Chassis mo = new Chassis();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        mo.setEntIndex(Integer.valueOf(chassisIndex));
        INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID);
        try {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devID);
            queryContext.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus", "standbyStatus", "adminStatus"));
            netconfPoller.query(queryContext);
            boards.addAll(queryContext.getQueryResult(Board.class));
            subCards.addAll(queryContext.getQueryResult(SubCard.class));
            ports.addAll(queryContext.getQueryResult(Port.class));
        }
        catch (VMFException e) {
            logger.error("query entitys from device failed!", (Throwable)e);
        }
    }

    public static void query(int devID, int boardIndex, List<SubCard> subCards, List<Port> ports) {
        if (null == subCards || null == ports) {
            return;
        }
        Board mo = new Board();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        mo.setEntIndex(Integer.valueOf(boardIndex));
        INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID);
        try {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devID);
            queryContext.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus", "standbyStatus", "adminStatus"));
            netconfPoller.query(queryContext);
            subCards.addAll(queryContext.getQueryResult(SubCard.class));
            ports.addAll(queryContext.getQueryResult(Port.class));
        }
        catch (VMFException e) {
            logger.error("query entitys from device failed!", (Throwable)e);
        }
    }
}

