/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.netconf;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.inventory.model.InnerLink;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.inventory.fault.InnerLinkFault;
import com.huawei.vmf.netconf.service.TargetType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerLinkQuery {
    private static final Logger logger = LoggerFactory.getLogger(InnerLinkFault.class);

    public List<InnerLink> queryInnerLinks(int devID) throws VMFException {
        InnerLink mo = new InnerLink();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        ArrayList<InnerLink> innerLinks = new ArrayList<InnerLink>();
        try {
            INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID);
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devID);
            queryContext.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus"));
            netconfPoller.query(queryContext);
            return (List)queryContext.getQueryResult(InnerLink.class);
        }
        catch (Exception e) {
            logger.error("query innerlink error: ", (Throwable)e);
            return innerLinks;
        }
    }

    public InnerLink queryInnerLink(int devID, String linkName) throws VMFException {
        InnerLink mo = new InnerLink();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        mo.setLinkName(linkName);
        try {
            INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID, (TargetType)TargetType.CDB);
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devID);
            queryContext.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus"));
            netconfPoller.query(queryContext);
            return mo;
        }
        catch (Exception e) {
            logger.error("query innerlink error: ", (Throwable)e);
            return null;
        }
    }
}

