/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.netconf;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChassisQuery {
    private static final Logger logger = LoggerFactory.getLogger(ChassisQuery.class);

    public static Chassis query(int devID, String entClass, String position) {
        Chassis mo = new Chassis();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        mo.setEntityClass(entClass);
        mo.setEntPosition(position);
        INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID);
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devID);
        queryContext.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus", "standbyStatus"));
        try {
            netconfPoller.query(queryContext);
            Collection chassiss = queryContext.getQueryResult(Chassis.class);
            mo = null == chassiss || chassiss.isEmpty() ? null : (Chassis)chassiss.iterator().next();
            return mo;
        }
        catch (VMFException e) {
            logger.error("query entitys from device failed!", (Throwable)e);
            return null;
        }
    }
}

