/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.netconf;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardQuery {
    private static final Logger logger = LoggerFactory.getLogger(BoardQuery.class);

    public static Board query(int devID, String entClass, String position) {
        Board mo = new Board();
        mo.setDevID(Integer.valueOf(devID));
        mo.setVrID(Integer.valueOf(0));
        mo.setEntityClass(entClass);
        mo.setEntPosition(position);
        INetconfPoller netconfPoller = DeviceAccessorFactory.getNetconfPoller((int)devID);
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(devID);
        queryContext.addQueryAttributes(FeatureName.DEVM, (VmfMO)mo, Arrays.asList("operStatus", "standbyStatus"));
        try {
            netconfPoller.query(queryContext);
            Collection boards = queryContext.getQueryResult(Board.class);
            mo = null == boards || boards.isEmpty() ? null : (Board)boards.iterator().next();
            return mo;
        }
        catch (VMFException e) {
            logger.error("query entitys from device failed!", (Throwable)e);
            return null;
        }
    }
}

