/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.fault.AbsPhyEntityFault;
import com.huawei.vmf.adapter.inventory.netconf.PortQuery;
import com.huawei.vmf.adapter.inventory.netconf.SubCardQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCardFault
extends AbsPhyEntityFault {
    private static final int CARD_REMOVE_WARNINGID = 2505214;
    private static final int CARD_FAIL_WARNINGID = 2505216;
    private static final int CARD_INVALID_WARNINGID = 2505218;
    private static final Logger logger = LoggerFactory.getLogger(SubCardFault.class);

    public SubCardFault() {
        this.alarms.add(2505218);
        this.alarms.add(2505216);
        this.alarms.add(2505214);
        this.alarms.add(1101753);
        this.alarms.add(1101754);
        this.alarms.add(1101765);
        this.alarms.add(3065538);
        this.alarms.add(3065539);
        this.alarms.add(1101770);
        this.alarms.add(1101769);
        this.alarms.add(3070145);
    }

    @Override
    protected PhyEntity query(String fdn) {
        PhyEntity subCard = null;
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection subcards = dao.queryByKey(SubCard.class, Arrays.asList(this.getSubCardKey(fdn)), false);
            return subcards.isEmpty() ? null : (SubCard)subcards.iterator().next();
        }
        catch (VMFException e) {
            logger.error("queryInterface failed " + (Object)((Object)e));
            return subCard;
        }
    }

    private SubCard getSubCardKey(String fdn) {
        SlotUniResIDParser parser = new SlotUniResIDParser();
        parser.deserialize(fdn);
        SubCard subCard = new SubCard();
        subCard.setDevID(Integer.valueOf(parser.getDevID()));
        subCard.setChassisID(Integer.valueOf(parser.getFrameID()));
        subCard.setSlotID(Integer.valueOf(parser.getSlotID()));
        subCard.setSubSlotID(parser.getSubSlotID());
        return subCard;
    }

    @Override
    protected void setStatus(PhyEntity entity, int warningId, int flag) {
        SubCard subCard = (SubCard)entity;
        switch (warningId) {
            case 1101770: 
            case 2505216: 
            case 2505218: 
            case 3070145: {
                this.handleCardFault(subCard);
                break;
            }
            case 1101753: 
            case 1101754: 
            case 1101765: 
            case 2505214: 
            case 3065538: 
            case 3065539: {
                this.handleCardRemove(subCard, flag);
            }
        }
    }

    private void handleCardFault(SubCard subCard) {
        SubCard devSubCard = SubCardQuery.query(subCard.getDevID(), subCard.getEntityClass(), subCard.getEntPosition());
        if (null == devSubCard || null == devSubCard.getOperStatus()) {
            logger.error("query subCard from device failed! devID=" + subCard.getDevID() + " entIndex=" + subCard.getEntIndex());
            return;
        }
        subCard.setOperStatus(devSubCard.getOperStatus());
    }

    private void handleCardRemove(SubCard subCard, int flag) {
        if (flag == 1) {
            subCard.setOperStatus(Integer.valueOf(4));
        }
        if (flag == 2) {
            subCard.setOperStatus(Integer.valueOf(3));
        }
    }

    @Override
    protected void updateStatus(PhyEntity entity, int warningId) {
        SubCard subCard = (SubCard)entity;
        Context ctx = new Context();
        try {
            if (null != subCard.getOperStatus()) {
                ctx.addChangeRecord(SubCard.class).addModify((Object)subCard, new PropertyChangeItem("operStatus"));
            }
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            dao.merge(SubCard.class, false);
            if (null != subCard.getOperStatus() && 4 == subCard.getOperStatus()) {
                this.updateChildrenSatus2Offline(subCard, ctx);
            } else {
                this.updatePorts(subCard, ctx);
            }
            dao.merge(Port.class, false);
        }
        catch (VMFException e) {
            logger.error("Update subCard status error!", (Throwable)e);
        }
    }

    private void updateChildrenSatus2Offline(SubCard subCard, Context ctx) {
        Port port = new Port();
        port.setDevID(subCard.getDevID());
        port.setChassisID(subCard.getChassisID());
        port.setSlotID(subCard.getSlotID());
        port.setSubSlotID(subCard.getSubSlotID());
        port.setOperStatus(Integer.valueOf(4));
        ctx.addChangeRecord(Port.class).addModify((Object)port, new PropertyChangeItem("operStatus"));
    }

    private void updatePorts(SubCard subCard, Context ctx) {
        Board board = this.queryBoard(subCard);
        List<Port> ports = PortQuery.query(subCard.getDevID(), board.getEntIndex());
        IMOChangeRecord record = ctx.addChangeRecord(Port.class);
        for (Port port : ports) {
            record.addModify((Object)port, Arrays.asList("adminStatus", "operStatus"));
        }
    }

    private Board queryBoard(SubCard subCard) {
        Board board = null;
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection boards = dao.queryByKey(Board.class, Arrays.asList(this.getBoardKey(subCard)), false);
            board = boards.isEmpty() ? null : (Board)boards.iterator().next();
        }
        catch (VMFException e) {
            logger.error("queryInterface failed " + (Object)((Object)e));
        }
        return board;
    }

    private Board getBoardKey(SubCard subCard) {
        Board board = new Board();
        board.setDevID(subCard.getDevID());
        board.setChassisID(subCard.getChassisID());
        board.setSlotID(subCard.getSlotID());
        return board;
    }

    @Override
    protected String getPhyEntityType() {
        return "SC";
    }
}

