/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.cache.InventoryTypeMappingCache;
import com.huawei.vmf.adapter.inventory.fault.AbsPhyEntityFault;
import com.huawei.vmf.adapter.inventory.netconf.PortQuery;
import com.huawei.vmf.adapter.inventory.notifyclient.ClientMessageSenderUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortFault
extends AbsPhyEntityFault {
    private static final Logger logger = LoggerFactory.getLogger(PortFault.class);
    private static final int OPTICAL_EQUIPPED = 1;
    private static final int OPTICAL_NOT_EQUIPPED = 0;
    private static final int OPTICAL_REMOVE_WARNINGID = 2505220;
    private static final int OPTICAL_TRANSMODE_UNKNOWN = 0;
    private static final int PORT_DOWN_WARNINGID = 2505274;
    private static final int PORT_DOWN_WARNINGID_1 = 1101787;

    public PortFault() {
        this.alarms.add(2505274);
        this.alarms.add(1101787);
        this.alarms.add(2505220);
        this.alarms.add(3074752);
        this.alarms.add(3065541);
        this.alarms.add(1100353);
        this.alarms.add(1100354);
        this.alarms.add(2505220);
        this.alarms.add(3);
        this.alarms.add(3067844);
        this.alarms.add(3067848);
    }

    public void handleICUFault(String fdn, String faultPara) {
        logger.info("handle ICU fault, fdn=" + fdn + "faultPara=" + faultPara);
        SlotUniResIDParser parser = new SlotUniResIDParser();
        parser.deserialize(fdn);
        String boardInfo = null;
        int devId = parser.getDevID();
        String[] paraArray = faultPara.split("=");
        if (null != paraArray && paraArray.length == 2) {
            boardInfo = paraArray[1];
        }
        String[] boardInfoArray = boardInfo.split("-");
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            if (null != boardInfoArray && boardInfoArray.length > 0) {
                for (String boardPosition : boardInfoArray) {
                    Board boardIndex = new Board();
                    boardIndex.setDevID(Integer.valueOf(devId));
                    boardIndex.setEntPosition(boardPosition);
                    Collection boards = dao.queryByFields(Board.class, new String[]{"devID", "entPosition"}, Arrays.asList(boardIndex), false);
                    for (Board board : boards) {
                        String typeName = InventoryTypeMappingCache.getTypeName(Board.class, board.getBoardType());
                        if (typeName.indexOf("ICU") < 0) continue;
                        Port port = new Port();
                        port.setDevID(board.getDevID());
                        port.setChassisID(board.getChassisID());
                        port.setSlotID(board.getSlotID());
                        port.setSubSlotID(Integer.valueOf(-1));
                        Collection icuPortList = dao.queryByKey(Port.class, Arrays.asList(port), false);
                        for (Port icuPort : icuPortList) {
                            Constructor<?> constructor = icuPort.getClass().getConstructor(icuPort.getClass());
                            Port dbEntity = (Port)constructor.newInstance(icuPort);
                            this.setPortStatus(icuPort, -1);
                            if (icuPort.getOperStatus().equals(dbEntity.getOperStatus())) continue;
                            this.updateStatus((PhyEntity)icuPort, -1);
                        }
                    }
                }
            }
        }
        catch (VMFException e) {
            logger.error("handle ICU fault failed, info=" + faultPara, (Throwable)e);
            return;
        }
        catch (Exception e) {
            ClientMessageSenderUtil.sendMessageToClient();
            logger.error("handle alarm has error: ", (Throwable)e);
        }
    }

    @Override
    public void notifyPhyEntityStatChange(PhyEntity dbEntity, PhyEntity entity) {
        logger.info("begin to notify port stat change");
        Context ctx = new Context();
        IMOChangeRecord moChangeRecord = ctx.addChangeRecord(Port.class);
        Port dbPort = (Port)dbEntity;
        Port port = (Port)entity;
        if (!port.getOperStatus().equals(dbPort.getOperStatus())) {
            moChangeRecord.addModify((Object)port, new PropertyChangeItem("operStatus", (Object)port.getOperStatus(), (Object)dbPort.getOperStatus()));
        }
        if (null != port.getOpticalIsEquipped() && null != dbPort.getOpticalIsEquipped() && !port.getOpticalIsEquipped().equals(dbPort.getOpticalIsEquipped())) {
            moChangeRecord.addModify((Object)port, new PropertyChangeItem("opticalIsEquipped", (Object)port.getOpticalIsEquipped(), (Object)dbPort.getOpticalIsEquipped()));
        }
        if (moChangeRecord.hasChanges()) {
            MOChangePublisher.getInstance().notifyAlarmChanges(ctx);
        }
        logger.info("end to notify port stat change");
    }

    @Override
    protected String getPhyEntityType() {
        return "PP";
    }

    @Override
    protected PhyEntity query(String fdn) {
        PhyEntity port = null;
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection ports = dao.queryByFields(Port.class, new String[]{"devID", "chassisID", "subSlotID", "parentRelPosition", "name"}, this.getPortConditions(fdn), false);
            return ports.isEmpty() ? null : (Port)ports.iterator().next();
        }
        catch (VMFException e) {
            logger.error("query ports failed ", (Throwable)e);
            return port;
        }
    }

    @Override
    protected void setStatus(PhyEntity entity, int warningId, int flag) {
        Port port = (Port)entity;
        switch (warningId) {
            case 1101787: 
            case 2505274: 
            case 3074752: {
                this.setPortStatus(port, flag);
                break;
            }
            case 1100353: 
            case 1100354: 
            case 2505220: 
            case 3065541: {
                this.setOpticalEquipped(port, flag);
                break;
            }
        }
    }

    @Override
    protected void updateStatus(PhyEntity entity, int warningId) {
        Port port = (Port)entity;
        Context ctx = new Context();
        IMOChangeRecord portChangeRecord = ctx.addChangeRecord(Port.class);
        if (null != port.getAdminStatus()) {
            portChangeRecord.addModify((Object)port, new PropertyChangeItem("adminStatus"));
        }
        if (null != port.getOperStatus()) {
            portChangeRecord.addModify((Object)port, new PropertyChangeItem("operStatus"));
        }
        if (null != port.getOpticalIsEquipped()) {
            portChangeRecord.addModify((Object)port, new PropertyChangeItem("opticalIsEquipped"));
        }
        if (null != port.getOptTransMode()) {
            portChangeRecord.addModify((Object)port, new PropertyChangeItem("optTransMode"));
        }
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            dao.merge(Port.class, false);
        }
        catch (VMFException e) {
            logger.error("Update port status error!", (Throwable)e);
        }
    }

    private Collection<Port> getPortConditions(String fdn) {
        ArrayList<Port> conditions = new ArrayList<Port>();
        PortUniResIDParser parser = new PortUniResIDParser();
        parser.deserialize(fdn);
        Port port = new Port();
        port.setDevID(Integer.valueOf(parser.getDevID()));
        port.setChassisID(Integer.valueOf(parser.getFrameID()));
        port.setSubSlotID(parser.getSubSlotID());
        port.setParentRelPosition(Integer.valueOf(parser.getPortID()));
        port.setName(parser.getCliName());
        conditions.add(port);
        return conditions;
    }

    private void setOpticalEquipped(Port port, int flag) {
        if (flag == 1) {
            port.setOpticalIsEquipped(Integer.valueOf(0));
            port.setOptTransMode(Integer.valueOf(0));
        } else if (flag == 2) {
            port.setOpticalIsEquipped(Integer.valueOf(1));
            port.setOptTransMode(Port.OPT_TRANS_MODE_ENUM.SINGLE_MODE);
        }
    }

    private void setPortStatus(Port port, int flag) {
        Port devPort = PortQuery.query(port.getDevID(), port.getEntityClass(), port.getEntPosition());
        if (null != devPort) {
            logger.info("query port status success.");
            port.setAdminStatus(devPort.getAdminStatus());
            port.setOperStatus(devPort.getOperStatus());
        } else {
            logger.info("query failed, just set alarm estate.");
            if (flag == 1) {
                port.setAdminStatus(Port.ENT_ADMIN_STATE_ENUM.INACTIVE);
                port.setOperStatus(Integer.valueOf(3));
            } else if (flag == 2) {
                port.setOperStatus(Integer.valueOf(2));
            }
        }
    }
}

