/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.inventory.fault.AbsPhyEntityFault;
import com.huawei.vmf.adapter.inventory.fault.FreshDevInfo;
import com.huawei.vmf.adapter.inventory.fault.PortFault;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class InventoryFaultListener
implements IFaultListener {
    public static final Logger logger = RunLogger.getLogger(InventoryFaultListener.class);
    private static final AbsPhyEntityFault portFault = new PortFault();
    private int DELAY_TIME = 10;
    Map<Integer, FreshDevInfo> freshDevInfoMap = new LinkedHashMap<Integer, FreshDevInfo>();

    public void handle(List<AsnForwardFaultRptStrc> asnForwardFaultRptStrcs) {
        for (AsnForwardFaultRptStrc asnForwardFaultRptStrc : asnForwardFaultRptStrcs) {
            int faultID = asnForwardFaultRptStrc.sFaultID.intValue();
            String fdn = StringUtil.globalString((byte[])asnForwardFaultRptStrc.strFdn);
            logger.info("hannd inventory fault. faultID : " + faultID + " fdn : " + fdn);
            StrUIDParser parser = new StrUIDParser();
            if (!parser.parse(fdn) || null == parser.getMOC()) {
                logger.error("parse fdn fail or moc is null. fdn : " + fdn);
                continue;
            }
            int devID = Integer.parseInt(parser.strValue("NE"));
            String moc = parser.getMOC();
            logger.info("hannd inventory fault. devID : " + devID + " moc : " + moc);
            if ("FR".equals(moc) || "CP".equals(moc) || "SC".equals(moc) || "PP".equals(moc)) {
                this.addFreshDevID(devID);
            }
            if (!"PP".equals(moc)) continue;
            portFault.handle(asnForwardFaultRptStrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFreshDevID(int devID) {
        Map<Integer, FreshDevInfo> map = this.freshDevInfoMap;
        synchronized (map) {
            if (!this.freshDevInfoMap.containsKey(devID)) {
                logger.info("add devID freshDevInfoMap. devID : " + devID);
                this.freshDevInfoMap.put(devID, new FreshDevInfo(devID, this.DELAY_TIME));
            } else {
                logger.info("fresh the DELAY_TIME in freshDevInfoMap. devID : " + devID);
                FreshDevInfo devDelayFreshInfo = this.freshDevInfoMap.get(devID);
                if (this.DELAY_TIME != devDelayFreshInfo.getDelayTime()) {
                    devDelayFreshInfo.setDelayTime(this.DELAY_TIME);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FreshDevInfo> getFreshDevInfos() {
        ArrayList<FreshDevInfo> freshDevInfos = new ArrayList<FreshDevInfo>();
        Map<Integer, FreshDevInfo> map = this.freshDevInfoMap;
        synchronized (map) {
            Set<Map.Entry<Integer, FreshDevInfo>> entrySet = this.freshDevInfoMap.entrySet();
            Iterator<Map.Entry<Integer, FreshDevInfo>> iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, FreshDevInfo> entry = iterator.next();
                FreshDevInfo freshDevInfo = entry.getValue();
                freshDevInfo.setDelayTime(freshDevInfo.getDelayTime() - 5);
                logger.info("the freshDevInfo detail info. devID : " + freshDevInfo.getDevID() + " delayTime : " + freshDevInfo.getDelayTime());
                if (freshDevInfo.getDelayTime() > 0) continue;
                logger.info("the delayTime is less than zero. devID : " + freshDevInfo.getDevID() + " delayTime : " + freshDevInfo.getDelayTime());
                freshDevInfos.add(freshDevInfo);
                iterator.remove();
            }
        }
        return freshDevInfos;
    }
}

