/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.NEUniResIDParser;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.InnerLink;
import com.huawei.vmf.adapter.inventory.netconf.InnerLinkQuery;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerLinkFault {
    public static final int EMF_VIEW_ID_PHYSIC = 1;
    public static final String IDENTIFY = ":";
    public static final String PHY = "PHY:";
    private static final List<Integer> alarms;
    private static final Logger logger;

    public List<Integer> concernAlarmIDs() {
        return alarms;
    }

    public void handle(AsnForwardFaultRptStrc fault) {
        if (!this.check(fault)) {
            return;
        }
        this.handleInnerLinkFault(fault);
    }

    private boolean check(AsnForwardFaultRptStrc cfgTrap) {
        if (null == cfgTrap) {
            logger.warn("InnerLinkFault in Trap is null!!");
            return false;
        }
        if (null == cfgTrap.strPara || 0 == cfgTrap.strPara.length) {
            logger.warn("AsnForwardFaultRptStrc strFdn in Trap is invalid!");
            return false;
        }
        return true;
    }

    private Integer getDevID(String fdn) {
        logger.debug("link trap fdn = " + fdn);
        if (null == fdn) {
            return null;
        }
        NEUniResIDParser parser = new NEUniResIDParser();
        parser.deserialize(fdn);
        return parser.getDevID();
    }

    private void handleInnerLinkFault(AsnForwardFaultRptStrc cfgTrap) {
        logger.info("Receive a Fault trap:" + cfgTrap);
        String fdn = new String(cfgTrap.strFdn);
        int devId = this.getDevID(fdn);
        InnerLinkQuery query = new InnerLinkQuery();
        List<InnerLink> deviceInnerLinks = null;
        Context ctx = new Context();
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            IMOChangeRecord record = ctx.addChangeRecord(InnerLink.class);
            deviceInnerLinks = query.queryInnerLinks(devId);
            for (InnerLink innerLink : deviceInnerLinks) {
                record.addModify((Object)innerLink, Arrays.asList("operStatus"));
            }
            if (record.hasChanges()) {
                dao.merge(InnerLink.class, false);
                MOChangePublisher.getInstance().notifyAlarmChanges(ctx);
            }
        }
        catch (VMFException e) {
            logger.error("handle innerlink fault error: ", (Throwable)e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(InnerLinkFault.class);
        alarms = new ArrayList<Integer>(1);
        alarms.add(3);
        alarms.add(4);
        alarms.add(2502001);
        alarms.add(2502002);
        alarms.add(1101761);
        alarms.add(3067844);
        alarms.add(3067845);
        alarms.add(3067848);
        alarms.add(0x2ECCC2);
    }
}

