/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.inventory.fault.AbstractPanelActionManager;
import com.huawei.vmf.adapter.inventory.netconf.BoardQuery;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import org.osgi.service.event.Event;

public class DevmActionManager
extends AbstractPanelActionManager {
    public void handleEvent(Event arg0) {
        logger.debug("start handle reset board event");
        String deviceIP = (String)arg0.getProperty("deviceIP");
        String cardIndex = (String)arg0.getProperty("cardIndex");
        logger.debug("deviceIP is " + deviceIP + " cardIndex is " + cardIndex);
        if (null == deviceIP || null == cardIndex) {
            logger.error("deviceIP or cardIndex is null.");
            return;
        }
        Integer devId = this.getDeviceIDByIP(deviceIP);
        Integer cardId = Integer.parseInt(cardIndex);
        Board index = new Board();
        index.setDevID(devId);
        Context ctx = new Context();
        try {
            Board board = new Board();
            board.setDevID(devId);
            board.setEntIndex(cardId);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            Collection boards = dao.queryByFields(Board.class, new String[]{"devID", "entIndex"}, Arrays.asList(board), false);
            if (boards.isEmpty()) {
                logger.warn("No entity found from db !");
                return;
            }
            board = (Board)boards.iterator().next();
            Constructor<?> constructor = board.getClass().getConstructor(board.getClass());
            Board dbEntity = (Board)constructor.newInstance(board);
            this.setBrdOperStatus(board, ctx);
            dao.merge(Board.class, false);
            if (null != dbEntity) {
                this.notifyPhyEntityStatChange((PhyEntity)dbEntity, (PhyEntity)board);
            }
        }
        catch (Exception e) {
            logger.error("duplicate entity failed!", (Throwable)e);
        }
        logger.debug("finish handle reset board event");
    }

    @Override
    protected void updateStatus(PhyEntity entity) {
    }

    private void setBrdOperStatus(Board board, Context ctx) {
        if ("FAN".equals(board.getVendorType())) {
            Board devBoard = BoardQuery.query(board.getDevID(), board.getEntityClass(), board.getEntPosition());
            if (null == devBoard || null == devBoard.getOperStatus()) {
                logger.error("can't get board from device,devID=" + board.getDevID() + " slotID=" + devBoard.getSlotID());
                return;
            }
            board.setOperStatus(devBoard.getOperStatus());
        }
        board.setOperStatus(Integer.valueOf(1));
        ctx.addChangeRecord(Board.class).addModify((Object)board, new PropertyChangeItem("operStatus"));
    }
}

