/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.fault.AbsPhyEntityFault;
import com.huawei.vmf.adapter.inventory.netconf.ChassisQuery;
import com.huawei.vmf.adapter.inventory.netconf.PhyEntityQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChassisFault
extends AbsPhyEntityFault {
    private static final int CHASSIS_FAIL_WARNINGID = 2505202;
    private static final int CHASSIS_INVALID_WARNINGID = 2505204;
    private static final int CHASSIS_REMOVE_WARNINGID = 2505200;
    private static final Logger logger = LoggerFactory.getLogger(ChassisFault.class);

    public ChassisFault() {
        this.alarms.add(1101753);
        this.alarms.add(1101754);
        this.alarms.add(1101765);
        this.alarms.add(2505200);
        this.alarms.add(2505202);
        this.alarms.add(2505204);
        this.alarms.add(1101770);
        this.alarms.add(1101769);
        this.alarms.add(3065540);
    }

    @Override
    protected String getPhyEntityType() {
        return "FR";
    }

    @Override
    protected PhyEntity query(String fdn) {
        Chassis chassis = null;
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection chassises = dao.queryByKey(Chassis.class, Arrays.asList(this.getChassisKey(fdn)), false);
            chassis = chassises.isEmpty() ? null : (Chassis)chassises.iterator().next();
        }
        catch (VMFException e) {
            logger.error("query chassis failed ", (Throwable)e);
        }
        return chassis;
    }

    @Override
    protected void setStatus(PhyEntity entity, int warningId, int flag) {
        Chassis chassis = (Chassis)entity;
        switch (warningId) {
            case 2505202: 
            case 2505204: {
                this.handleChassisFail(chassis);
                break;
            }
            case 1101753: 
            case 1101754: 
            case 1101765: 
            case 2505200: 
            case 3065540: {
                this.handleChassisRemove(chassis, flag);
                break;
            }
            case 3066591: {
                this.handleChassisFail(chassis);
                break;
            }
        }
        logger.info("set chassis operStatus=" + chassis.getOperStatus() + " standby status=" + chassis.getStandbyStatus());
    }

    @Override
    protected void updateStatus(PhyEntity entity, int warningId) {
        Chassis chassis = (Chassis)entity;
        try {
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(Chassis.class);
            if (null != chassis.getOperStatus()) {
                record.addModify((Object)chassis, new PropertyChangeItem("operStatus"));
            }
            if (null != chassis.getStandbyStatus()) {
                record.addModify((Object)chassis, new PropertyChangeItem("standbyStatus"));
            }
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            dao.merge(Chassis.class, false);
            if (null != chassis.getOperStatus() && 4 == chassis.getOperStatus()) {
                this.updateChildrenSatus2Offline(chassis, ctx);
            } else {
                this.updateChildrenStatus(chassis, ctx);
            }
            dao.merge(Board.class, false);
            dao.merge(SubCard.class, false);
            dao.merge(Port.class, false);
        }
        catch (VMFException e) {
            logger.error("Update status error!", (Throwable)e);
        }
    }

    private Chassis getChassisKey(String fdn) {
        SlotUniResIDParser parser = new SlotUniResIDParser();
        parser.deserialize(fdn);
        Chassis chassis = new Chassis();
        chassis.setDevID(Integer.valueOf(parser.getDevID()));
        chassis.setChassisID(Integer.valueOf(parser.getFrameID()));
        return chassis;
    }

    private void handleChassisFail(Chassis chassis) {
        Chassis devChassis = ChassisQuery.query(chassis.getDevID(), chassis.getEntityClass(), chassis.getEntPosition());
        if (null == devChassis || null == devChassis.getOperStatus()) {
            logger.error("query chassis from device failed! devID=" + chassis.getDevID() + " entIndex=" + chassis.getEntIndex());
            return;
        }
        chassis.setOperStatus(devChassis.getOperStatus());
    }

    private void handleChassisRemove(Chassis chassis, int flag) {
        if (flag == 1) {
            chassis.setOperStatus(Integer.valueOf(4));
        } else if (flag == 2) {
            chassis.setOperStatus(Integer.valueOf(2));
        }
    }

    private void updateChildrenSatus2Offline(Chassis chassis, Context ctx) {
        Board board = new Board();
        board.setDevID(chassis.getDevID());
        board.setChassisID(chassis.getChassisID());
        board.setOperStatus(Integer.valueOf(4));
        ctx.addChangeRecord(Board.class).addModify((Object)board, new PropertyChangeItem("operStatus"));
        SubCard subcard = new SubCard();
        subcard.setDevID(chassis.getDevID());
        subcard.setChassisID(chassis.getChassisID());
        subcard.setOperStatus(Integer.valueOf(4));
        ctx.addChangeRecord(SubCard.class).addModify((Object)subcard, new PropertyChangeItem("operStatus"));
        Port port = new Port();
        port.setDevID(chassis.getDevID());
        port.setChassisID(chassis.getChassisID());
        port.setOperStatus(Integer.valueOf(4));
        ctx.addChangeRecord(Port.class).addModify((Object)port, new PropertyChangeItem("operStatus"));
    }

    private void updateChildrenStatus(Chassis chassis, Context ctx) {
        ArrayList<Board> boards = new ArrayList<Board>();
        ArrayList<SubCard> subCards = new ArrayList<SubCard>();
        ArrayList<Port> ports = new ArrayList<Port>();
        PhyEntityQuery.query(chassis.getDevID(), chassis.getEntIndex(), boards, subCards, ports);
        IMOChangeRecord boardRecord = ctx.addChangeRecord(Board.class);
        IMOChangeRecord subCardRecord = ctx.addChangeRecord(SubCard.class);
        IMOChangeRecord portRecord = ctx.addChangeRecord(Port.class);
        for (Board board : boards) {
            boardRecord.addModify((Object)board, Arrays.asList("standbyStatus", "operStatus"));
        }
        for (SubCard subcard : subCards) {
            subCardRecord.addModify((Object)subcard, Arrays.asList("standbyStatus", "operStatus"));
        }
        for (Port port : ports) {
            portRecord.addModify((Object)port, Arrays.asList("standbyStatus", "operStatus"));
        }
    }
}

