/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.fault.AbstractPanelActionManager;
import com.huawei.vmf.adapter.inventory.netconf.PortQuery;
import com.huawei.vmf.adapter.inventory.notifyclient.ClientMessageSenderUtil;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import org.osgi.service.event.Event;

public class ChangePortActionManager
extends AbstractPanelActionManager {
    public void handleEvent(Event event) {
        logger.info("start handle change port status event");
        String deviceIP = (String)event.getProperty("deviceIP");
        String portIndex = (String)event.getProperty("portIndex");
        logger.info("deviceIP is " + deviceIP + " portIndex is " + portIndex);
        if (null == deviceIP || null == portIndex) {
            logger.error("deviceIP or portIndex is null.");
            return;
        }
        Integer devId = this.getDeviceIDByIP(deviceIP);
        Integer portId = Integer.parseInt(portIndex);
        Context ctx = new Context();
        try {
            Port port = new Port();
            port.setDevID(devId);
            port.setEntIndex(portId);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            Collection ports = dao.queryByFields(Port.class, new String[]{"devID", "entIndex"}, Arrays.asList(port), false);
            if (ports.isEmpty()) {
                logger.warn("No port found from db !portIndex =" + portIndex);
                return;
            }
            port = (Port)ports.iterator().next();
            Constructor<?> constructor = port.getClass().getConstructor(port.getClass());
            Port dbPort = (Port)constructor.newInstance(port);
            this.setPortOperStatus(port, ctx);
            dao.merge(Port.class, false);
            if (null != dbPort) {
                this.notifyPhyEntityStatChange(dbPort, port);
            }
        }
        catch (Exception e) {
            logger.error("duplicate port entity failed!", (Throwable)e);
        }
        logger.info("finish handle reset board event");
    }

    private void setPortOperStatus(Port port, Context ctx) {
        Port devPort = PortQuery.query(port.getDevID(), port.getEntityClass(), port.getEntPosition());
        if (null == devPort || null == devPort.getOperStatus()) {
            logger.error("can't get port from device,devID=" + port.getDevID() + " slotID=" + devPort.getSlotID());
            return;
        }
        IMOChangeRecord moChangeRecord = ctx.addChangeRecord(Port.class);
        if (!devPort.getAdminStatus().equals(port.getAdminStatus())) {
            port.setAdminStatus(devPort.getAdminStatus());
            moChangeRecord.addModify((Object)port, new PropertyChangeItem("adminStatus"));
        }
        if (!devPort.getOperStatus().equals(port.getOperStatus())) {
            port.setOperStatus(devPort.getOperStatus());
            moChangeRecord.addModify((Object)port, new PropertyChangeItem("operStatus"));
        }
    }

    protected void updateStatus(PhyEntity entity, Context ctx) {
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            dao.merge(Port.class, false);
        }
        catch (VMFException e) {
            logger.error("Update port status error!", (Throwable)e);
        }
    }

    protected void notifyPhyEntityStatChange(Port dbPort, Port port) {
        boolean isAdminStatusChange;
        logger.info("begin to notify phyentity stat change");
        logger.info("entity class is " + port.getClass());
        Context ctx = new Context();
        IMOChangeRecord moChangeRecord = ctx.addChangeRecord(port.getClass());
        boolean isOperStatusChange = !port.getOperStatus().equals(dbPort.getOperStatus());
        boolean bl = isAdminStatusChange = !port.getAdminStatus().equals(dbPort.getAdminStatus());
        if (isOperStatusChange || isAdminStatusChange) {
            if (isOperStatusChange) {
                moChangeRecord.addModify((Object)port, new PropertyChangeItem("operStatus", (Object)port.getOperStatus(), (Object)dbPort.getOperStatus()));
            }
            if (isAdminStatusChange) {
                moChangeRecord.addModify((Object)port, new PropertyChangeItem("adminStatus", (Object)port.getAdminStatus(), (Object)dbPort.getAdminStatus()));
            }
            MOChangePublisher.getInstance().notifyChanges(ctx);
            ClientMessageSenderUtil.sendMessageToClient();
        }
        logger.info("end to notify phyentity stat change");
    }

    @Override
    protected void updateStatus(PhyEntity entity) {
    }
}

