/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.fault.AbsPhyEntityFault;
import com.huawei.vmf.adapter.inventory.fault.AlarmIdConstant;
import com.huawei.vmf.adapter.inventory.netconf.BoardQuery;
import com.huawei.vmf.adapter.inventory.netconf.ChassisQuery;
import com.huawei.vmf.adapter.inventory.netconf.PhyEntityQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardFault
extends AbsPhyEntityFault {
    private static final int BOARD_BECOME_MASTER_WARNINGID = 2505213;
    private static final int BOARD_FAIL_WARNINGID = 2505208;
    private static final int BOARD_INVALID_WARNINGID = 2505210;
    private static final int BOARD_LEAVE_MASTER_WARNINGID = 2505212;
    private static final int BOARD_REMOVE_WARNINGID = 2505206;
    private static final int FAN_FAIL_WARNINGID = 2505236;
    private static final int FAN_INVALID_WARNINGID = 2505238;
    private static final int FAN_REMOVE_WARNINGID = 2505234;
    private static final int FAN_UNUSABLE_WARNINGID = 2505240;
    private static final Logger logger = LoggerFactory.getLogger(BoardFault.class);
    private static final int POWER_FAIL_WARNINGID = 2505228;
    private static final int POWER_INVALID_WARNINGID = 2505230;
    private static final int POWER_REMOVE_WARNINGID = 2505226;
    private static final int POWER_UNUSABLE_WARNINGID = 2505232;
    private final List<Integer> boardAlarms;

    public BoardFault() {
        this.alarms.add(2505208);
        this.alarms.add(2505210);
        this.alarms.add(2505206);
        this.alarms.add(2505213);
        this.alarms.add(2505212);
        this.alarms.add(2505228);
        this.alarms.add(2505226);
        this.alarms.add(2505230);
        this.alarms.add(2505232);
        this.alarms.add(2505234);
        this.alarms.add(2505236);
        this.alarms.add(2505238);
        this.alarms.add(2505240);
        this.boardAlarms = new ArrayList<Integer>();
        this.boardAlarms.add(2505208);
        this.boardAlarms.add(2505210);
        this.boardAlarms.add(2505206);
        this.boardAlarms.add(2505213);
        this.boardAlarms.add(2505212);
        this.alarms.add(1101753);
        this.alarms.add(1101754);
        this.alarms.add(1101765);
        this.alarms.add(3065536);
        this.alarms.add(1100045);
        this.alarms.add(1100046);
        this.alarms.add(1100423);
        this.alarms.add(1100424);
        this.alarms.add(2505266);
        this.alarms.add(3065537);
        this.alarms.add(3066561);
        this.alarms.add(3066566);
        this.alarms.add(3066568);
        this.alarms.add(3066576);
        this.alarms.add(3066590);
        this.alarms.add(1101757);
        this.alarms.add(1101770);
        this.alarms.add(1101769);
        this.alarms.add(3070144);
        this.alarms.add(1101764);
        this.alarms.add(1101763);
        this.alarms.add(2500858);
        this.alarms.add(1100338);
        this.alarms.add(3068609);
        this.alarms.add(3068608);
        this.alarms.add(3067591);
        this.alarms.add(3067592);
        this.alarms.add(3067599);
        this.alarms.add(1100841);
        this.alarms.add(1100842);
        this.alarms.add(3067595);
        this.alarms.add(1100273);
        this.alarms.add(1100274);
        this.alarms.add(3067594);
        this.alarms.add(1100570);
        this.alarms.add(3067765);
        this.alarms.add(3069131);
        this.alarms.addAll(AlarmIdConstant.HW_ENTITY_POWER_ALARMS);
        this.boardAlarms.add(1101753);
        this.boardAlarms.add(1101754);
        this.boardAlarms.add(1101765);
        this.boardAlarms.add(3065536);
        this.boardAlarms.add(3065537);
        this.boardAlarms.add(3066561);
        this.boardAlarms.add(3066566);
        this.boardAlarms.add(3066568);
        this.boardAlarms.add(3066576);
        this.boardAlarms.add(1101757);
        this.boardAlarms.add(1101770);
        this.boardAlarms.add(1101769);
        this.boardAlarms.add(3070144);
        this.boardAlarms.add(1101764);
        this.boardAlarms.add(1101763);
        this.boardAlarms.add(2500858);
        this.boardAlarms.add(1100338);
        this.boardAlarms.add(3068609);
        this.boardAlarms.add(3068608);
        this.boardAlarms.add(3067591);
        this.boardAlarms.add(3067592);
        this.boardAlarms.add(3067599);
        this.boardAlarms.add(3067595);
        this.boardAlarms.add(3067594);
        this.boardAlarms.add(3067765);
        this.boardAlarms.add(3069131);
        this.boardAlarms.addAll(AlarmIdConstant.HW_ENTITY_POWER_ALARMS);
    }

    public void handleMPUBecomeMaster(String fdn, String locationInfo, int warningId) {
        String[] paraArray;
        logger.info("handle become master, fdn=" + fdn + "locationInfo=" + locationInfo);
        String devId = null;
        String entPosition = null;
        String[] fdnArray = fdn.split("=");
        if (null != fdnArray && fdnArray.length == 2) {
            devId = fdnArray[1];
        }
        if (null != (paraArray = locationInfo.split(" ")) && paraArray.length == 2) {
            entPosition = paraArray[1];
        }
        try {
            if (null != devId && null != entPosition) {
                Board board = new Board();
                board.setDevID(Integer.valueOf(devId));
                board.setEntPosition(entPosition);
                IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
                Collection boards = dao.queryByFields(Board.class, new String[]{"devID", "entPosition"}, Arrays.asList(board), false);
                Board board2 = board = boards.isEmpty() ? null : (Board)boards.iterator().next();
                if (board != null) {
                    this.handleBrdSwitch(board, true);
                    this.updateStatus((PhyEntity)board, warningId);
                }
            }
        }
        catch (VMFException e) {
            logger.error("handle MPU become master failed, entPosition=" + entPosition, (Throwable)e);
            return;
        }
    }

    public void handlePowerFanRemove(String deviceIp, String locationName, String entityClass, int flag) {
        if (null == deviceIp || null == locationName) {
            return;
        }
        if (flag == 1) {
            return;
        }
        try {
            String entityName;
            String[] entityNameArray;
            IDeviceService deivceService = Activator.getDeviceService();
            int deviceId = deivceService.getDevIDByIP(deviceIp);
            logger.info("location name is " + locationName);
            String[] locationArray = locationName.split("=");
            if (null != locationArray && locationArray.length == 2 && null != (entityNameArray = (entityName = locationArray[1]).split(" ")) && entityNameArray.length == 3) {
                Board board = BoardQuery.query(deviceId, entityClass, entityNameArray[2]);
                Context ctx = new Context();
                ctx.addChangeRecord(Board.class).addCreate((Object)board);
                IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
                dao.merge(Board.class, false);
            }
        }
        catch (VMFException e) {
            logger.error("handle power and fan remove failed : ", (Throwable)e);
            return;
        }
    }

    @Override
    protected String getPhyEntityType() {
        return "CP";
    }

    @Override
    protected PhyEntity query(String fdn) {
        Board board = null;
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            Collection boards = dao.queryByKey(Board.class, Arrays.asList(this.getBoardKey(fdn)), false);
            board = boards.isEmpty() ? null : (Board)boards.iterator().next();
        }
        catch (VMFException e) {
            logger.error("query board failed ", (Throwable)e);
        }
        return board;
    }

    @Override
    protected void setStatus(PhyEntity entity, int warningId, int flag) {
        this.boardAlarms.add(3067591);
        this.boardAlarms.add(3067592);
        this.boardAlarms.add(3067599);
        this.boardAlarms.add(1100841);
        this.boardAlarms.add(1100842);
        this.boardAlarms.addAll(AlarmIdConstant.HW_ENTITY_POWER_ALARMS);
        Board board = (Board)entity;
        switch (warningId) {
            case -30: 
            case 1100356: 
            case 1100357: 
            case 1100415: 
            case 1100416: 
            case 1100417: 
            case 1100418: 
            case 1100419: 
            case 1100420: 
            case 1100421: 
            case 1100422: 
            case 1100568: 
            case 1100841: 
            case 1100842: 
            case 1100843: 
            case 1100844: 
            case 1101770: 
            case 2505208: 
            case 2505210: 
            case 2505228: 
            case 2505230: 
            case 2505232: 
            case 2505236: 
            case 2505238: 
            case 2505240: 
            case 3067591: 
            case 3067592: 
            case 3067593: 
            case 3067599: 
            case 3067765: 
            case 3070144: {
                this.handleBrdFail(board);
                break;
            }
            case 1100045: 
            case 1100046: 
            case 1100423: 
            case 1100424: 
            case 1101753: 
            case 1101754: 
            case 1101765: 
            case 2505206: 
            case 2505266: 
            case 3065536: 
            case 3065537: {
                this.handleBrdRemove(board, flag);
                break;
            }
            case 1101764: 
            case 2505213: 
            case 3068609: {
                this.handleBrdSwitch(board, true);
                break;
            }
            case 1100338: 
            case 1101763: 
            case 2500858: 
            case 2505212: 
            case 3068608: {
                this.handleBrdSwitch(board, false);
                break;
            }
            case 1101757: 
            case 3066561: 
            case 3066566: 
            case 3066568: 
            case 3066576: 
            case 3066590: {
                this.handleBrdReset(board, flag);
                break;
            }
            case 3069131: {
                this.handleBrdPowerOff(board, flag);
                break;
            }
            case 1100273: 
            case 1100274: 
            case 1100570: 
            case 2505226: 
            case 2505234: 
            case 3067594: 
            case 3067595: {
                this.handlePowerFanRemove(board, flag);
            }
        }
        logger.info("set board operStatus=" + board.getOperStatus() + " standby status=" + board.getStandbyStatus());
    }

    @Override
    protected void updateStatus(PhyEntity entity, int warningId) {
        Board board = (Board)entity;
        try {
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(Board.class);
            if (board.getOperStatus() != null) {
                record.addModify((Object)board, new PropertyChangeItem("operStatus"));
            }
            if (board.getStandbyStatus() != null) {
                record.addModify((Object)board, new PropertyChangeItem("standbyStatus"));
            }
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            dao.merge(Board.class, false);
            if (this.hasChildren(warningId)) {
                if (null != board.getOperStatus() && (4 == board.getOperStatus() || 1 == board.getOperStatus())) {
                    this.updateChildrenSatus2Offline(board, ctx);
                } else {
                    this.updateChildrenStatus(board, ctx);
                }
                dao.merge(SubCard.class, false);
                dao.merge(Port.class, false);
            }
        }
        catch (VMFException e) {
            logger.error("Update board status error!", (Throwable)e);
        }
    }

    private Board getBoardKey(String fdn) {
        SlotUniResIDParser parser = new SlotUniResIDParser();
        parser.deserialize(fdn);
        Board board = new Board();
        board.setDevID(Integer.valueOf(parser.getDevID()));
        board.setChassisID(Integer.valueOf(parser.getFrameID()));
        board.setSlotID(Integer.valueOf(parser.getSlotID()));
        return board;
    }

    private void handleBrdFail(Board board) {
        this.setBrdOperStatus(board);
    }

    private void handleBrdPowerOff(Board board, int flag) {
        Board devBoard = null;
        try {
            devBoard = BoardQuery.query(board.getDevID(), board.getEntityClass(), board.getEntPosition());
        }
        catch (Exception e) {
            logger.error("query failed." + board.getDevID() + " slotID=" + board.getSlotID() + e);
        }
        if (null == devBoard || null == devBoard.getOperStatus()) {
            logger.error("can't get board from device,devID=" + board.getDevID() + " slotID=" + board.getSlotID());
            return;
        }
        board.setOperStatus(devBoard.getOperStatus());
    }

    private void handleBrdRemove(Board board, int flag) {
        if (flag == 1) {
            board.setOperStatus(Integer.valueOf(4));
        } else if (flag == 2) {
            board.setOperStatus(Integer.valueOf(1));
        }
    }

    private void handleBrdReset(Board board, int flag) {
        if (flag == 1) {
            board.setOperStatus(Integer.valueOf(1));
        } else if (flag == 2) {
            board.setOperStatus(Integer.valueOf(2));
        }
    }

    private void handleBrdSwitch(Board board, boolean isBecomeMaster) {
        ServiceReference ref = Activator.getContext().getServiceReference(IDeviceService.class.getName());
        IDeviceService devService = (IDeviceService)Activator.getContext().getService(ref);
        try {
            boolean isMulti = devService.isMultiChassisDevice(board.getDevID().intValue());
            this.setBrdStandByStatus(board, isBecomeMaster, isMulti);
            if (isMulti) {
                this.handleChassisSwitch(board, isBecomeMaster);
            }
        }
        catch (VMFException e) {
            logger.error("query data from db failed!", (Throwable)e);
        }
    }

    private void handleChassisSwitch(Board board, boolean isBecomeMaster) {
        Chassis key = new Chassis();
        key.setDevID(board.getDevID());
        key.setChassisID(board.getChassisID());
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        try {
            Collection chassises = dao.queryByKey(Chassis.class, Arrays.asList(key), false);
            if (!chassises.isEmpty()) {
                Chassis chassis = (Chassis)chassises.iterator().next();
                this.setChassisStandbyStat(chassis, board, isBecomeMaster);
                ctx.addChangeRecord(Chassis.class).addModify((Object)chassis, new PropertyChangeItem("standbyStatus"));
                dao.merge(Chassis.class, false);
            }
        }
        catch (VMFException e) {
            logger.error("query and update chassis from db failed!", (Throwable)e);
        }
    }

    private void handlePowerFanRemove(Board board, int flag) {
        if (flag == 1) {
            Context ctx = new Context();
            ctx.addChangeRecord(Board.class).addDelete((Object)board);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            try {
                dao.merge(Board.class, false);
            }
            catch (VMFException e) {
                logger.error("delete power and fan data from database failed : ", (Throwable)e);
            }
        } else if (flag == 2) {
            board.setOperStatus(Integer.valueOf(1));
        }
    }

    private boolean hasChildren(int warningId) {
        return this.boardAlarms.contains(warningId);
    }

    private void setBoardStandbyStatusDirect(Board board, boolean isBecomeMaster, boolean isMulti) {
        logger.info("set board standby status directly.");
        if (isBecomeMaster && isMulti) {
            board.setStandbyStatus(Integer.valueOf(3));
        } else if (isBecomeMaster) {
            board.setStandbyStatus(Integer.valueOf(0));
        } else {
            board.setStandbyStatus(Integer.valueOf(1));
        }
    }

    private void setBrdOperStatus(Board board) {
        Board devBoard = null;
        try {
            devBoard = BoardQuery.query(board.getDevID(), board.getEntityClass(), board.getEntPosition());
        }
        catch (Exception e) {
            logger.error("query failed." + board.getDevID() + " slotID=" + board.getSlotID() + e);
            logger.info("set board standby status directly.");
        }
        if (null == devBoard || null == devBoard.getOperStatus()) {
            logger.error("can't get board from device,devID=" + board.getDevID() + " slotID=" + board.getSlotID());
            return;
        }
        board.setOperStatus(devBoard.getOperStatus());
        board.setStandbyStatus(devBoard.getStandbyStatus());
    }

    private void setBrdStandByStatus(Board board, boolean isBecomeMaster, boolean isMulti) {
        Board devBoard = null;
        try {
            devBoard = BoardQuery.query(board.getDevID(), board.getEntityClass(), board.getEntPosition());
        }
        catch (Exception e) {
            logger.error("query failed." + board.getDevID() + " slotID=" + board.getSlotID() + e);
            this.setBoardStandbyStatusDirect(board, isBecomeMaster, isMulti);
            return;
        }
        if (null == devBoard || null == devBoard.getOperStatus()) {
            logger.error("can't get board from device,devID=" + board.getDevID() + " slotID=" + board.getSlotID());
            this.setBoardStandbyStatusDirect(board, isBecomeMaster, isMulti);
            return;
        }
        board.setOperStatus(devBoard.getOperStatus());
        board.setStandbyStatus(devBoard.getStandbyStatus());
    }

    private void setChassisStandbyStat(Chassis dbChassis, Board board, boolean isBecomeMaster) {
        Chassis chassis = null;
        try {
            chassis = ChassisQuery.query(dbChassis.getDevID(), dbChassis.getEntityClass(), dbChassis.getEntPosition());
        }
        catch (Exception e) {
            logger.error("query failed." + board.getDevID() + " slotID=" + board.getSlotID() + e);
            this.setChassisStandbyStatusDirect(dbChassis, isBecomeMaster);
            return;
        }
        if (null == chassis || null == chassis.getStandbyStatus()) {
            logger.error("query chassis standby status from device null!");
            this.setChassisStandbyStatusDirect(dbChassis, isBecomeMaster);
            return;
        }
        dbChassis.setStandbyStatus(chassis.getStandbyStatus());
    }

    private void setChassisStandbyStatusDirect(Chassis chassis, boolean isBecomeMaster) {
        logger.info("set chassis standby status directly.");
        if (isBecomeMaster) {
            chassis.setStandbyStatus(Integer.valueOf(3));
        } else {
            chassis.setStandbyStatus(Integer.valueOf(4));
        }
    }

    private void updateChildrenSatus2Offline(Board board, Context ctx) {
        SubCard subcard = new SubCard();
        subcard.setDevID(board.getDevID());
        subcard.setChassisID(board.getChassisID());
        subcard.setSlotID(board.getSlotID());
        subcard.setOperStatus(Integer.valueOf(4));
        ctx.addChangeRecord(SubCard.class).addModify((Object)subcard, new PropertyChangeItem("operStatus"));
        Port port = new Port();
        port.setDevID(board.getDevID());
        port.setChassisID(board.getChassisID());
        port.setSlotID(board.getSlotID());
        port.setOperStatus(Integer.valueOf(4));
        ctx.addChangeRecord(Port.class).addModify((Object)port, new PropertyChangeItem("operStatus"));
    }

    private void updateChildrenStatus(Board board, Context ctx) {
        ArrayList<SubCard> subCards = new ArrayList<SubCard>();
        ArrayList<Port> ports = new ArrayList<Port>();
        PhyEntityQuery.query(board.getDevID(), board.getEntIndex(), subCards, ports);
        IMOChangeRecord subCardRecord = ctx.addChangeRecord(SubCard.class);
        IMOChangeRecord portRecord = ctx.addChangeRecord(Port.class);
        for (SubCard subcard : subCards) {
            subCardRecord.addModify((Object)subcard, new PropertyChangeItem("operStatus"));
        }
        for (Port port : ports) {
            portRecord.addModify((Object)port, new PropertyChangeItem("adminStatus"));
            portRecord.addModify((Object)port, new PropertyChangeItem("operStatus"));
        }
    }
}

