/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.uflight.threadpool.ThreadPool;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.fservice.sync.service.ISyncService;
import com.huawei.vmf.adapter.fservice.sync.service.ISynchronizeJobProgressListener;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.fault.FreshDevInfo;
import com.huawei.vmf.adapter.inventory.fault.InventoryFaultListener;
import com.huawei.vmf.adapter.inventory.notifyclient.ClientMessageSenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;

public class AlarmFreshDevTask
extends TimerTask {
    public static final Logger logger = RunLogger.getLogger(AlarmFreshDevTask.class);
    public static final int INTERVAL = 5;
    private InventoryFaultListener inventoryFaultListener;
    private List<Integer> freshDevIDs = new ArrayList<Integer>();
    private final ISynchronizeJobProgressListener listener = new ISynchronizeJobProgressListener(){

        public void handleProgress(int neID, int progress, int errorCode, String detail) {
            if (100 == progress) {
                if (0 != errorCode) {
                    logger.error("sync devm data error. devId=" + neID + " errorCode=" + errorCode + " detail=" + detail);
                } else {
                    logger.info("sync devm data succ. devId=" + neID);
                }
                ClientMessageSenderUtil.sendMessageToClient();
                logger.info("finish sync the devm data and remove the fresh device. devID : " + neID);
                AlarmFreshDevTask.this.freshDevIDs.remove((Object)neID);
            }
        }
    };

    public AlarmFreshDevTask(InventoryFaultListener inventoryFaultListener) {
        this.inventoryFaultListener = inventoryFaultListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("start alarmFreshDevTask.");
        List<FreshDevInfo> freshDevInfos = this.inventoryFaultListener.getFreshDevInfos();
        for (FreshDevInfo freshDevInfo : freshDevInfos) {
            int devID = freshDevInfo.getDevID();
            logger.info("start run the alarmFreshDevTask. devId : " + devID);
            List<Integer> list = this.freshDevIDs;
            synchronized (list) {
                if (this.freshDevIDs.contains(devID)) {
                    logger.info("the device is aready sync devm data. devId : " + devID);
                    continue;
                }
                this.freshDevIDs.add(devID);
            }
            logger.info("start syncDevmDataThread. devId : " + devID);
            SyncDevmDataThread syncDevmDataThread = new SyncDevmDataThread(devID);
            ThreadPool.getInstance().execute((Runnable)syncDevmDataThread);
        }
    }

    private class SyncDevmDataThread
    implements Runnable {
        private Integer devID;

        public SyncDevmDataThread(Integer devID) {
            this.devID = devID;
        }

        @Override
        public void run() {
            ISyncService service = (ISyncService)Activator.getService(ISyncService.class);
            try {
                logger.info("the device is sync devm data. devId : " + this.devID);
                service.singleFeatureSync(this.devID.intValue(), FeatureName.DEVM, new ISynchronizeJobProgressListener[]{AlarmFreshDevTask.this.listener});
            }
            catch (VMFException e) {
                logger.error("manunalSyncDevuceAndWait fail. " + (Object)((Object)e));
                AlarmFreshDevTask.this.freshDevIDs.remove(this.devID);
            }
        }
    }
}

