/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.notifyclient.ClientMessageSenderUtil;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPanelActionManager
implements EventHandler {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractPanelActionManager.class);

    protected Integer getDeviceIDByIP(String deviceIP) {
        Integer deviceID = null;
        try {
            deviceID = Activator.getDeviceService().getDevIDByIP(deviceIP);
        }
        catch (VMFException e) {
            logger.error("can't get deviceID from deviceIP, maybe the data is deleted in the database.");
        }
        return deviceID;
    }

    protected void notifyPhyEntityStatChange(PhyEntity dbEntity, PhyEntity entity) {
        logger.info("begin to notify phyentity stat change");
        logger.info("entity class is " + entity.getClass());
        Context ctx = new Context();
        if (!entity.getOperStatus().equals(dbEntity.getOperStatus())) {
            IMOChangeRecord moChangeRecord = ctx.addChangeRecord(entity.getClass());
            moChangeRecord.addModify((Object)entity, new PropertyChangeItem("operStatus", (Object)entity.getOperStatus(), (Object)dbEntity.getOperStatus()));
            MOChangePublisher.getInstance().notifyChanges(ctx);
            ClientMessageSenderUtil.sendMessageToClient();
        }
        logger.info("end to notify phyentity stat change");
    }

    protected abstract void updateStatus(PhyEntity var1);
}

