/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.fault;

import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.fault.BoardFault;
import com.huawei.vmf.adapter.inventory.fault.PortFault;
import com.huawei.vmf.adapter.inventory.notifyclient.ClientMessageSenderUtil;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsPhyEntityFault {
    private static final Logger logger = LoggerFactory.getLogger(AbsPhyEntityFault.class);
    protected List<Integer> alarms = new ArrayList<Integer>();
    private boolean isNotify = false;

    public List<Integer> concernAlarmIDs() {
        return this.alarms;
    }

    public void handle(AsnForwardFaultRptStrc fault) {
        if (!this.check((FStruct)fault) && !this.checkfFdn((FStruct)fault)) {
            return;
        }
        AsnForwardFaultRptStrc cfgTrap = fault;
        int warningId = cfgTrap.sFaultID.intValue();
        if (!this.needProcess(warningId)) {
            logger.error("the fault ID is not in concerning IDs!,warningId=" + warningId);
            return;
        }
        this.isNotify = false;
        String fdn = StringUtil.globalString((byte[])cfgTrap.strFdn);
        logger.info("begin to handle entity alarm,warningId=" + warningId + " fdn=" + fdn + " flag=" + cfgTrap.cFaultFlag.intValue());
        try {
            PhyEntity entity;
            logger.info("query entity from db,fdn=" + fdn);
            PhyEntity phyEntity = entity = warningId == 3067844 || warningId == 3067848 ? null : this.query(StringUtil.globalString((byte[])cfgTrap.strFdn));
            if (null == entity) {
                boolean shouldRefreshClient = false;
                if (warningId == 3067594 || warningId == 1100570) {
                    BoardFault boardFault = new BoardFault();
                    boardFault.handlePowerFanRemove(new String(cfgTrap.strHostIP), new String(cfgTrap.strPara), "powerSupply", cfgTrap.cFaultFlag.intValue());
                    shouldRefreshClient = true;
                } else if (warningId == 3067595 || warningId == 1100273 || warningId == 1100274) {
                    BoardFault boardFault = new BoardFault();
                    boardFault.handlePowerFanRemove(new String(cfgTrap.strHostIP), new String(cfgTrap.strPara), "fan", cfgTrap.cFaultFlag.intValue());
                    shouldRefreshClient = true;
                } else if (warningId == 1101764 || warningId == 3068609) {
                    BoardFault boardFault = new BoardFault();
                    boardFault.handleMPUBecomeMaster(StringUtil.globalString((byte[])cfgTrap.strFdn), StringUtil.globalString((byte[])cfgTrap.strPara), warningId);
                    shouldRefreshClient = true;
                } else if (warningId == 3067844 || warningId == 3067848) {
                    PortFault portFault = new PortFault();
                    portFault.handleICUFault(StringUtil.globalString((byte[])cfgTrap.strFdn), StringUtil.globalString((byte[])cfgTrap.strPara));
                    shouldRefreshClient = true;
                }
                if (shouldRefreshClient) {
                    ClientMessageSenderUtil.sendMessageToClient();
                }
                logger.warn("No entity found from db !fdn=" + fdn);
                return;
            }
            PhyEntity dbEntity = null;
            Constructor<?> constructor = entity.getClass().getConstructor(entity.getClass());
            dbEntity = (PhyEntity)constructor.newInstance(entity);
            Port dbPort = null;
            if (entity instanceof Port) {
                dbPort = (Port)constructor.newInstance(entity);
                dbPort.setOpticalIsEquipped(((Port)entity).getOpticalIsEquipped());
            }
            this.setStatus(entity, warningId, cfgTrap.cFaultFlag.intValue());
            if (warningId == 3067594 || warningId == 3067595) {
                ClientMessageSenderUtil.sendMessageToClient();
                logger.info("entity is power or fan, finised process.");
                return;
            }
            this.updateStatus(entity, warningId);
            if (null != dbEntity) {
                if (entity instanceof Port) {
                    this.notifyPhyEntityStatChange((PhyEntity)dbPort, entity);
                } else {
                    this.notifyPhyEntityStatChange(dbEntity, entity);
                }
            }
            if (!this.isNotify) {
                ClientMessageSenderUtil.sendMessageToClient();
            }
        }
        catch (Exception e) {
            ClientMessageSenderUtil.sendMessageToClient();
            logger.error("handle alarm has error: ", (Throwable)e);
        }
    }

    protected abstract String getPhyEntityType();

    protected void notifyPhyEntityStatChange(PhyEntity dbEntity, PhyEntity entity) {
        logger.info("begin to notify phyentity stat change");
        logger.info("entity class is " + dbEntity.getClass());
        Context ctx = new Context();
        if (!entity.getOperStatus().equals(dbEntity.getOperStatus())) {
            logger.info("entity's operstatus is not equal to dbEntity.operstatus,will notifyChanges");
            IMOChangeRecord moChangeRecord = ctx.addChangeRecord(entity.getClass());
            moChangeRecord.addModify((Object)entity, new PropertyChangeItem("operStatus", (Object)entity.getOperStatus(), (Object)dbEntity.getOperStatus()));
            MOChangePublisher.getInstance().notifyAlarmChanges(ctx);
            this.isNotify = true;
        }
        logger.info("end to notify phyentity stat change");
    }

    protected abstract PhyEntity query(String var1);

    protected abstract void setStatus(PhyEntity var1, int var2, int var3);

    protected abstract void updateStatus(PhyEntity var1, int var2);

    private boolean check(FStruct fault) {
        if (null == fault) {
            logger.warn("fault in Trap is null!!");
            return false;
        }
        if (!(fault instanceof AsnForwardFaultRptStrc)) {
            logger.warn("AsnForwardFaultRptStrc strFdn in Trap is not AsnForwardFaultRptStrc object.");
            return false;
        }
        AsnForwardFaultRptStrc cfgTrap = (AsnForwardFaultRptStrc)fault;
        if (null == cfgTrap.strPara || 0 == cfgTrap.strPara.length) {
            logger.warn("AsnForwardFaultRptStrc strFdn in Trap is invalid!");
            return false;
        }
        return true;
    }

    private boolean checkfFdn(FStruct fault) {
        String mOCString;
        AsnForwardFaultRptStrc cfgTrap = (AsnForwardFaultRptStrc)fault;
        String fdnString = StringUtil.globalString((byte[])cfgTrap.strFdn);
        if (null == fdnString || fdnString.equals("undefined") || fdnString.equals("") || fdnString.equals("null")) {
            return false;
        }
        StrUIDParser fdnParser = new StrUIDParser();
        return fdnParser.parse(fdnString) && (mOCString = fdnParser.getMOC()).equals(this.getPhyEntityType());
    }

    private boolean needProcess(int warningId) {
        return this.alarms.contains(warningId);
    }
}

