/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.dao;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.RelationMetaMgr;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.springframework.util.CollectionUtils;

public class RuModuleInfoDao
extends DefaultDao {
    protected RuModuleInfoDao(SessionFactory sf, RelationMetaMgr relationMgr) {
        super(sf, relationMgr);
    }

    public <T extends PhyEntity> Map<T, RuModuleInfo> queryRuModuleMap(Collection<T> entities) throws VMFException {
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyMap();
        }
        HashMap<RuModuleInfo, PhyEntity> entityMap = new HashMap<RuModuleInfo, PhyEntity>(entities.size());
        for (PhyEntity phyEntity : entities) {
            RuModuleInfo moduleIndex = new RuModuleInfo();
            moduleIndex.setDevID(phyEntity.getDevID());
            moduleIndex.setPhyIndex(phyEntity.getEntIndex());
            entityMap.put(moduleIndex, phyEntity);
        }
        Collection ruModules = this.queryByKey(RuModuleInfo.class, entityMap.keySet(), false);
        HashMap<PhyEntity, RuModuleInfo> rs = new HashMap<PhyEntity, RuModuleInfo>(entities.size());
        for (RuModuleInfo ruModuleInfo : ruModules) {
            PhyEntity entity = (PhyEntity)entityMap.get(ruModuleInfo);
            if (entity == null) continue;
            rs.put(entity, ruModuleInfo);
        }
        return rs;
    }
}

