/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.compatibility;

import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardRecord;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSubBoardDataReq;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.imap.MdpSessionImpl;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCardType;
import com.huawei.vmf.adapter.inventory.compatibility.BoardTypeCache;
import com.huawei.vmf.adapter.inventory.compatibility.SubCardTypeCache;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCardTypeMgr {
    public static final int QCMD_INV_SUBBOARD_INSERT = 11536237;
    public static final int SUBSLOT_MAIN_TYPE = 5;
    protected static final Logger logger = LoggerFactory.getLogger(SubCardTypeMgr.class);
    private SubCardType subCardType;

    public SubCardTypeMgr(SubCardType subCardType) {
        this.subCardType = subCardType;
    }

    public static boolean isNewType(int typeID) {
        int subTypeID = Integer.parseInt("500000000" + typeID);
        return BoardTypeCache.containsType(subTypeID);
    }

    public SubCardType getNewType() {
        int subTypeID = Integer.parseInt("500000000" + this.subCardType.getSubCardTypeID());
        return new SubCardType(Integer.valueOf(subTypeID), this.subCardType.getSubCardTypeName());
    }

    public void saveNewType(SubCardType subCardType) {
        SubCardTypeCache.insert(subCardType);
        this.sendMsgToInvForAddResSub(subCardType.getSubCardTypeID(), subCardType.getTypeName());
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            ctx.addChangeRecord(SubCardType.class).addCreate((Object)subCardType);
            dao.merge(SubCardType.class, false);
        }
        catch (VMFException e) {
            logger.error("insert boardType to db error!", (Throwable)e);
        }
    }

    private void sendMsgToInvForAddResSub(int iSubType, String strCardName) {
        QAsnSubBoardDataReq asnSubBoardReq = new QAsnSubBoardDataReq();
        QAsnBoardRecord oBoardRecord = new QAsnBoardRecord();
        oBoardRecord.iBoardID = BigInteger.valueOf(iSubType);
        oBoardRecord.strBoardName = strCardName.getBytes();
        oBoardRecord.strFullName = strCardName.getBytes();
        oBoardRecord.strDataOwner = "IP".getBytes();
        asnSubBoardReq.recordList.add((Object)oBoardRecord);
        MdpSessionImpl session = new MdpSessionImpl();
        int result = session.sendAyncMessage('\u0bcf', (byte)0, 11536237, (FStruct)asnSubBoardReq);
        if (0 != result) {
            logger.error("sendMsgToInvForAddResSub: SendNotifyMsg failed. iRec = " + result);
        }
    }
}

