/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.compatibility;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCardTypeCache {
    protected static final Logger logger = LoggerFactory.getLogger(SubCardTypeCache.class);
    private static final Map<Integer, String> map = new HashMap<Integer, String>();

    public static synchronized boolean containsType(int subCardTypeID) {
        if (map.isEmpty()) {
            SubCardTypeCache.load();
        }
        return map.containsKey(subCardTypeID);
    }

    private static void load() {
        Collection list = null;
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            list = dao.queryAll(SubCardType.class, false);
            for (SubCardType subCardType : list) {
                map.put(subCardType.getSubCardTypeID(), subCardType.getSubCardTypeName());
            }
        }
        catch (VMFException e) {
            logger.error("query board type from db failed!", (Throwable)e);
        }
    }

    public static synchronized void insert(SubCardType subCardType) {
        if (SubCardTypeCache.containsType(subCardType.getTypeId())) {
            logger.info("the subcard type already exists,no need to update cache!,typeID=" + subCardType.getSubCardTypeID());
            return;
        }
        map.put(subCardType.getSubCardTypeID(), subCardType.getSubCardTypeName());
    }
}

