/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.compatibility;

import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardRecord;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSubBoardDataReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSubBoardDataRsp;
import com.huawei.vmf.adapter.common.imap.MdpSessionImpl;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCardType;
import com.swimap.imap.common.asn1.common.AsnResSubTypeTab;
import com.swimap.imap.common.asn1.common.AsnTopoRegisterStaticInfoReq;
import com.swimap.imap.common.asn1.common.AsnTopoRegisterStaticInfoReqSeqOf1;
import com.swimap.imap.common.asn1.common.AsnTopoRespMsg;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCardNotifier {
    protected static final Logger logger = LoggerFactory.getLogger(SubCardNotifier.class);
    private SubCardType subCardType;

    public SubCardNotifier(SubCardType subCardType) {
        this.subCardType = subCardType;
    }

    public void notifyInventory() {
        QAsnSubBoardDataReq req = new QAsnSubBoardDataReq();
        QAsnBoardRecord record = new QAsnBoardRecord();
        record.iBoardID = BigInteger.valueOf(this.subCardType.getSubCardTypeID().intValue());
        record.strBoardName = this.subCardType.getSubCardTypeName().getBytes();
        record.strDataOwner = "IP".getBytes();
        record.strFullName = this.subCardType.getSubCardTypeName().getBytes();
        req.recordList.add((Object)record);
        QAsnSubBoardDataRsp rsp = new QAsnSubBoardDataRsp();
        MdpSessionImpl session = new MdpSessionImpl();
        int result = session.sendSyncMessage('\u0bcf', (byte)8, 11536237, (FStruct)req, (FStruct)rsp);
        if (result != 0 || rsp.result.result != 0) {
            logger.error("notify inventory to register subcard Type error,ret = " + result);
        }
    }

    public void notifyTopo() {
        AsnTopoRespMsg rsp = new AsnTopoRespMsg();
        AsnTopoRegisterStaticInfoReq req = new AsnTopoRegisterStaticInfoReq();
        req.lstResSubType = new AsnTopoRegisterStaticInfoReqSeqOf1();
        AsnResSubTypeTab tab = new AsnResSubTypeTab();
        tab.iMainTypeID = BigInteger.valueOf(5L);
        tab.iSubTypeID = BigInteger.valueOf(this.subCardType.getSubCardTypeID().intValue());
        tab.strName = this.subCardType.getSubCardTypeName().getBytes();
        MdpSessionImpl session = new MdpSessionImpl();
        int result = session.sendSyncMessage('3', (byte)0, 259, (FStruct)req, (FStruct)rsp);
        if (result != 0 || rsp.iReturnCode.intValue() != 0) {
            logger.error("notify topo to register subcard Type error,ret = " + result);
        }
    }
}

