/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.compatibility;

import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardDataReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardDataRsp;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardRecord;
import com.huawei.vmf.adapter.common.imap.MdpSessionImpl;
import com.huawei.vmf.adapter.fservice.inventory.model.BoardType;
import com.swimap.imap.common.asn1.common.AsnResSubTypeTab;
import com.swimap.imap.common.asn1.common.AsnTopoRegisterStaticInfoReq;
import com.swimap.imap.common.asn1.common.AsnTopoRegisterStaticInfoReqSeqOf1;
import com.swimap.imap.common.asn1.common.AsnTopoRespMsg;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardTypeNotifier {
    protected static final Logger logger = LoggerFactory.getLogger(BoardTypeNotifier.class);
    private BoardType boardType;

    public BoardTypeNotifier(BoardType boardType) {
        this.boardType = boardType;
    }

    public void notifyInventory() {
        QAsnBoardDataReq req = new QAsnBoardDataReq();
        QAsnBoardRecord record = new QAsnBoardRecord();
        record.iBoardID = BigInteger.valueOf(this.boardType.getBoardTypeID().intValue());
        record.strBoardName = this.boardType.getBoardTypeName().getBytes();
        record.strDataOwner = "IP".getBytes();
        record.strFullName = this.boardType.getBoardTypeName().getBytes();
        req.recordList.add((Object)record);
        QAsnBoardDataRsp rsp = new QAsnBoardDataRsp();
        MdpSessionImpl session = new MdpSessionImpl();
        int result = session.sendSyncMessage('\u0bcf', (byte)8, 11536231, (FStruct)req, (FStruct)rsp);
        if (result != 0 || rsp.result.result != 0) {
            logger.error("notify inventory to register boardType error,ret = " + result);
        }
    }

    public void notifyTopo() {
        AsnTopoRespMsg rsp = new AsnTopoRespMsg();
        AsnTopoRegisterStaticInfoReq req = new AsnTopoRegisterStaticInfoReq();
        req.lstResSubType = new AsnTopoRegisterStaticInfoReqSeqOf1();
        AsnResSubTypeTab tab = new AsnResSubTypeTab();
        tab.iMainTypeID = BigInteger.valueOf(4L);
        tab.iSubTypeID = BigInteger.valueOf(this.boardType.getBoardTypeID().intValue());
        tab.strName = this.boardType.getBoardTypeName().getBytes();
        MdpSessionImpl session = new MdpSessionImpl();
        int result = session.sendSyncMessage('3', (byte)0, 259, (FStruct)req, (FStruct)rsp);
        if (result != 0 || rsp.iReturnCode.intValue() != 0) {
            logger.error("notify topo to register boardType error,ret = " + result);
        }
    }
}

