/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.compatibility;

import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardDataReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardRecord;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.imap.MdpSessionImpl;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.BoardType;
import com.huawei.vmf.adapter.inventory.compatibility.BoardTypeCache;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardTypeMgr {
    public static final int QCMD_INV_BOARD_INSERT = 11536231;
    public static final int SLOT_MAIN_TYPE = 4;
    protected static final Logger logger = LoggerFactory.getLogger(BoardTypeMgr.class);
    private BoardType boardType;

    public BoardTypeMgr(BoardType boardType) {
        this.boardType = boardType;
    }

    public BoardType getNewType() {
        int subTypeID = Integer.parseInt("400000000" + this.boardType.getBoardTypeID());
        return new BoardType(Integer.valueOf(subTypeID), this.boardType.getBoardTypeName());
    }

    public boolean isNewType() {
        int subTypeID = Integer.parseInt("400000000" + this.boardType.getBoardTypeID());
        return BoardTypeCache.containsType(subTypeID);
    }

    public void saveNewType(BoardType boardType) {
        BoardTypeCache.insert(boardType);
        this.sendMsgToInvForAddResSub(boardType.getBoardTypeID(), boardType.getTypeName());
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            ctx.addChangeRecord(BoardType.class).addCreate((Object)boardType);
            dao.merge(BoardType.class, false);
        }
        catch (VMFException e) {
            logger.error("insert boardType to db error!", (Throwable)e);
        }
    }

    private void sendMsgToInvForAddResSub(int iSubType, String strCardName) {
        QAsnBoardDataReq asnBoardReq = new QAsnBoardDataReq();
        QAsnBoardRecord oBoardRecord = new QAsnBoardRecord();
        oBoardRecord.iBoardID = BigInteger.valueOf(iSubType);
        oBoardRecord.strBoardName = strCardName.getBytes();
        oBoardRecord.strFullName = strCardName.getBytes();
        oBoardRecord.strDataOwner = "IP".getBytes();
        asnBoardReq.recordList.add((Object)oBoardRecord);
        MdpSessionImpl session = new MdpSessionImpl();
        int result = session.sendAyncMessage('\u0bcf', (byte)0, 11536231, (FStruct)asnBoardReq);
        if (0 != result) {
            logger.error("sendMsgToInvForAddResSub: SendNotifyMsg failed. iRec = " + result);
        }
    }
}

