/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.compatibility;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.fservice.inventory.model.BoardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoardTypeCache {
    protected static final Logger logger = LoggerFactory.getLogger(BoardTypeCache.class);
    private static final Map<Integer, String> map = new HashMap<Integer, String>();

    public static synchronized boolean containsType(int boardTypeID) {
        if (map.isEmpty()) {
            BoardTypeCache.load();
        }
        return map.containsKey(boardTypeID);
    }

    private static void load() {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection list = null;
        try {
            list = dao.queryAll(BoardType.class, false);
            for (BoardType boardType : list) {
                map.put(boardType.getBoardTypeID(), boardType.getBoardTypeName());
            }
        }
        catch (VMFException e) {
            logger.error("query board type from db failed!", (Throwable)e);
        }
    }

    public static synchronized void insert(BoardType boardType) {
        if (BoardTypeCache.containsType(boardType.getTypeId())) {
            logger.info("the board type already exists,no need to update cache!,typeID=" + boardType.getTypeId());
            return;
        }
        map.put(boardType.getTypeId(), boardType.getBoardTypeName());
    }
}

