/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.cache;

import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfDataReq;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfDataRsp;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfRecord;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardDataReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardDataRsp;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnBoardRecord;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSubBoardDataReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSubBoardDataRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.imap.MdpSessionImpl;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.BoardType;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.ChassisType;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntityTypeMapping;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.PortType2InvPortType;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCardType;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class InventoryTypeMappingCache {
    private static final Logger logger = LoggerFactory.getLogger(InventoryTypeMappingCache.class);
    private static final Map<Class<? extends PhyEntity>, Class<?>> moTypeMappingClazzes;
    private static Map<Class<? extends PhyEntity>, Map<String, Integer>> phyEntityTypeInfos;

    public static Integer getTypeId(String typeName, Class<? extends PhyEntity> phyEntityClass, String systemOid) {
        Integer typeId;
        if (phyEntityTypeInfos.isEmpty()) {
            InventoryTypeMappingCache.load();
        }
        if (null != (typeId = InventoryTypeMappingCache.getCacheTypeId(typeName, phyEntityClass)) || null == systemOid) {
            return typeId;
        }
        logger.info("full sync devm typeID:InventoryTypeMappingCache.getTypeId for typeName=" + typeName + ",className=" + phyEntityClass.getName() + ",systemoid=" + systemOid);
        typeId = InventoryTypeMappingCache.getNewTypeId(systemOid);
        InventoryTypeMappingCache.registerTypeId(typeName, typeId, phyEntityClass);
        return typeId;
    }

    public static String getTypeName(Class<?> clazz, int typeId) {
        Map<String, Integer> moTypeMappingsMap;
        if (phyEntityTypeInfos.isEmpty()) {
            InventoryTypeMappingCache.load();
        }
        if (CollectionUtils.isEmpty(moTypeMappingsMap = phyEntityTypeInfos.get(clazz))) {
            logger.warn("moTypeMappingsMap is empty. clazz=" + clazz);
            return null;
        }
        for (Map.Entry<String, Integer> moTypeMappingsMapEntry : moTypeMappingsMap.entrySet()) {
            if (!moTypeMappingsMapEntry.getValue().equals(typeId)) continue;
            return moTypeMappingsMapEntry.getKey();
        }
        return null;
    }

    private static Integer getCacheTypeId(String typeName, Class<? extends PhyEntity> phyEntityClass) {
        Map<String, Integer> phyEntityTypeInfo = phyEntityTypeInfos.get(phyEntityClass);
        if (CollectionUtils.isEmpty(phyEntityTypeInfo)) {
            logger.warn("phyEntityTypeInfo is empty. phyEntityClass=" + phyEntityClass);
            return null;
        }
        Integer typeId = phyEntityTypeInfo.get(typeName);
        return typeId;
    }

    private static Integer getNewTypeId(String systemOid) {
        int endindex = systemOid.lastIndexOf(46);
        int startindex = systemOid.lastIndexOf(46, endindex - 1);
        String resTypeId = systemOid.substring(startindex + 1, endindex);
        String resID = systemOid.substring(endindex + 1);
        return (int)(Double.parseDouble(resTypeId) * Math.pow(10.0, 8.0) + Double.parseDouble(resID));
    }

    private static synchronized void load() {
        if (!phyEntityTypeInfos.isEmpty()) {
            return;
        }
        List tmpMoTypeMappings = null;
        HashMap<String, Integer> tmpMoTypeMappingsMap = null;
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            for (Map.Entry<Class<PhyEntity>, Class<?>> moTypeMappingClazzesEntry : moTypeMappingClazzes.entrySet()) {
                tmpMoTypeMappings = (List)dao.queryAll(moTypeMappingClazzesEntry.getValue(), false);
                tmpMoTypeMappingsMap = new HashMap<String, Integer>();
                for (PhyEntityTypeMapping tmpMoTypeMapping : tmpMoTypeMappings) {
                    tmpMoTypeMappingsMap.put(tmpMoTypeMapping.getTypeName(), tmpMoTypeMapping.getTypeId());
                }
                phyEntityTypeInfos.put(moTypeMappingClazzesEntry.getKey(), tmpMoTypeMappingsMap);
            }
        }
        catch (VMFException e) {
            logger.error("Query mo type mapping object error. moTypeMappingClazzes=" + moTypeMappingClazzes, (Throwable)e);
            phyEntityTypeInfos.clear();
        }
    }

    private static int notifyInventory(PhyEntityTypeMapping type) {
        int result = 0;
        if (type instanceof ChassisType) {
            QAsnShelfDataReq asnShelfDataReq = new QAsnShelfDataReq();
            QAsnShelfRecord oShelfRecord = new QAsnShelfRecord();
            oShelfRecord.iShelfID = BigInteger.valueOf(((ChassisType)type).getChassisTypeID().intValue());
            oShelfRecord.strShelfName = ((ChassisType)type).getChassisTypeName().getBytes();
            oShelfRecord.strTypedesc = ((ChassisType)type).getChassisTypeName().getBytes();
            oShelfRecord.strDataOwner = "IP".getBytes();
            asnShelfDataReq.recordList.add((Object)oShelfRecord);
            QAsnShelfDataRsp rsp = new QAsnShelfDataRsp();
            MdpSessionImpl session = new MdpSessionImpl();
            result = session.sendSyncMessage('\u0bcf', (byte)0, 11536873, (FStruct)asnShelfDataReq, (FStruct)rsp);
            if (result != 0 || rsp.result.result != 0) {
                logger.error("notify inventory to register chassis Type error,ret = " + result);
                return 1;
            }
        } else if (type instanceof BoardType) {
            QAsnBoardDataReq asnBoardReq = new QAsnBoardDataReq();
            QAsnBoardRecord oBoardRecord = new QAsnBoardRecord();
            oBoardRecord.iBoardID = BigInteger.valueOf(((BoardType)type).getTypeId());
            oBoardRecord.strBoardName = ((BoardType)type).getBoardTypeName().getBytes();
            oBoardRecord.strFullName = ((BoardType)type).getBoardTypeName().getBytes();
            oBoardRecord.strDataOwner = "IP".getBytes();
            asnBoardReq.recordList.add((Object)oBoardRecord);
            QAsnBoardDataRsp rsp = new QAsnBoardDataRsp();
            MdpSessionImpl session = new MdpSessionImpl();
            result = session.sendSyncMessage('\u0bcf', (byte)0, 11536231, (FStruct)asnBoardReq, (FStruct)rsp);
            if (result != 0 || rsp.result.result != 0) {
                logger.error("notify inventory to register chassis Type error,ret = " + result);
                return 1;
            }
        } else if (type instanceof SubCardType) {
            QAsnSubBoardDataReq req = new QAsnSubBoardDataReq();
            QAsnBoardRecord record = new QAsnBoardRecord();
            record.iBoardID = BigInteger.valueOf(((SubCardType)type).getSubCardTypeID().intValue());
            record.strBoardName = ((SubCardType)type).getSubCardTypeName().getBytes();
            record.strFullName = ((SubCardType)type).getSubCardTypeName().getBytes();
            record.strDataOwner = "IP".getBytes();
            req.recordList.add((Object)record);
            QAsnSubBoardDataRsp rsp = new QAsnSubBoardDataRsp();
            MdpSessionImpl session = new MdpSessionImpl();
            result = session.sendSyncMessage('\u0bcf', (byte)0, 11536237, (FStruct)req, (FStruct)rsp);
            if (result != 0 || rsp.result.result != 0) {
                logger.error("notify inventory to register chassis Type error,ret = " + result);
                return 1;
            }
        }
        return result;
    }

    private static synchronized void registerTypeId(String typeName, Integer typeId, Class<? extends PhyEntity> phyEntityClass) {
        if (!phyEntityClass.equals(Chassis.class) && !phyEntityClass.equals(Board.class) && !phyEntityClass.equals(SubCard.class) || null != InventoryTypeMappingCache.getCacheTypeId(typeName, phyEntityClass)) {
            return;
        }
        Class<?> phyEntityType = moTypeMappingClazzes.get(phyEntityClass);
        ChassisType newType = new ChassisType(typeId, typeName);
        if (phyEntityClass.equals(Board.class)) {
            newType = new BoardType(typeId, typeName);
        } else if (phyEntityClass.equals(SubCard.class)) {
            newType = new SubCardType(typeId, typeName);
        }
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        IMOChangeRecord addChangeRecord = ctx.addChangeRecord(phyEntityType);
        addChangeRecord.addCreate((Object)newType);
        try {
            dao.merge(phyEntityType, false);
            InventoryTypeMappingCache.notifyInventory((PhyEntityTypeMapping)newType);
        }
        catch (VMFException e) {
            logger.error("registe type id error. typeName=" + typeName + ", typeId=" + typeId, (Throwable)e);
            return;
        }
        Map<String, Integer> phyEntityTypeInfo = phyEntityTypeInfos.get(phyEntityClass);
        if (null == phyEntityTypeInfo) {
            phyEntityTypeInfo = new HashMap<String, Integer>();
        }
        phyEntityTypeInfo.put(typeName, typeId);
    }

    static {
        phyEntityTypeInfos = new HashMap<Class<? extends PhyEntity>, Map<String, Integer>>();
        moTypeMappingClazzes = new HashMap();
        moTypeMappingClazzes.put(Chassis.class, ChassisType.class);
        moTypeMappingClazzes.put(Board.class, BoardType.class);
        moTypeMappingClazzes.put(SubCard.class, SubCardType.class);
        moTypeMappingClazzes.put(Port.class, PortType2InvPortType.class);
    }
}

