/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory;

import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.vmf.adapter.common.exception.ServiceNotAvailableException;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.model.MOAdditionalInfoMgr;
import com.huawei.vmf.adapter.framework.notify.INotifyListener;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.schedule.VMFSchedulerFactory;
import com.huawei.vmf.adapter.framework.syncdata.INEUploadHandler;
import com.huawei.vmf.adapter.framework.syncdata.NEUploadHandlerHolder;
import com.huawei.vmf.adapter.framework.trapadmin.FaultConfiguration;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.CCUTransPack;
import com.huawei.vmf.adapter.inventory.fault.AlarmFreshDevTask;
import com.huawei.vmf.adapter.inventory.fault.ChangePortActionManager;
import com.huawei.vmf.adapter.inventory.fault.DevmActionManager;
import com.huawei.vmf.adapter.inventory.fault.InventoryFaultListener;
import com.huawei.vmf.adapter.inventory.notify.CardChangeListener;
import com.huawei.vmf.adapter.inventory.notify.ChassisChangeListener;
import com.huawei.vmf.adapter.inventory.notify.DeviceStatusChangeListener;
import com.huawei.vmf.adapter.inventory.notify.InnerLinkChangeListener;
import com.huawei.vmf.adapter.inventory.notify.PortChangeListener;
import com.huawei.vmf.adapter.inventory.syncdata.InventoryNEUploadHandler;
import com.huawei.vmf.adapter.inventory.task.InventoryQueryTask;
import com.huawei.vmf.adapter.inventory.task.InventoryTask;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class Activator
implements BundleActivator {
    public static final Logger LOGGER = RunLogger.getLogger(Activator.class);
    private static BundleContext ctx;
    private ServiceRegistration createRef;
    private ServiceRegistration deleteRef;
    private Activator INSTANCE;
    private InventoryFaultListener inventoryFaultListener = new InventoryFaultListener();
    private ServiceRegistration metaFacrotyRef;
    private ServiceRegistration translatorFacrotyRef;

    public static BundleContext getContext() {
        return ctx;
    }

    public static IDeviceService getDeviceService() throws VMFException {
        return (IDeviceService)Activator.getService(IDeviceService.class);
    }

    public static <T> T getService(Class<?> interfaceClazz) throws ServiceNotAvailableException {
        Assert.notNull(interfaceClazz, (String)"interfaceClazz must not be null.");
        ServiceReference serviceRef = Activator.getContext().getServiceReference(interfaceClazz.getName());
        if (null == serviceRef) {
            throw new ServiceNotAvailableException(interfaceClazz);
        }
        Object service = Activator.getContext().getService(serviceRef);
        if (null == service) {
            throw new ServiceNotAvailableException(interfaceClazz);
        }
        return (T)service;
    }

    public Activator getInstance() {
        return this.INSTANCE;
    }

    public void registerActionListeners() {
        String TOPIC_RESET_CARD_SUCCESS = "com/huawei/vmf/adapter/panel/util/PanelEventSender/ResetCard";
        Hashtable<String, String> resetCardProperties = new Hashtable<String, String>();
        ((Dictionary)resetCardProperties).put("event.topics", "com/huawei/vmf/adapter/panel/util/PanelEventSender/ResetCard");
        DevmActionManager resetCardHandler = new DevmActionManager();
        String TOPIC_CHANGE_PORT_SUCCESS = "com/huawei/vmf/adapter/panel/util/PanelEventSender/ChangePort";
        Hashtable<String, String> chgPortProperties = new Hashtable<String, String>();
        ((Dictionary)chgPortProperties).put("event.topics", "com/huawei/vmf/adapter/panel/util/PanelEventSender/ChangePort");
        ChangePortActionManager chgPortHandler = new ChangePortActionManager();
        BundleContext ctx = Activator.getContext();
        ctx.registerService(EventHandler.class.getName(), (Object)resetCardHandler, resetCardProperties);
        ctx.registerService(EventHandler.class.getName(), (Object)chgPortHandler, chgPortProperties);
    }

    public void registerFaultListener() {
        FaultConfiguration.getDefaultConfiguration().registerFaultListener(this.getClass().getPackage().getName(), (IFaultListener)this.inventoryFaultListener);
    }

    public void registry() {
        this.registerMoChangeListeners();
        this.registerActionListeners();
        this.registerFaultListener();
        TaskDispatcherMgr mgr = TaskDispatcherMgr.getInstance((ProcessInfo)ProcessInfoHelper.getRuntimeProcessInfo());
        mgr.registerTask(InventoryTask.class);
        mgr.registerTask(InventoryQueryTask.class);
        NEUploadHandlerHolder.getInstance().addListener((INEUploadHandler)new InventoryNEUploadHandler());
    }

    public void start(BundleContext context) throws Exception {
        this.INSTANCE = this;
        ctx = context;
        if ("independent".equals(System.getProperty("deploymentMode")) && ProcessInfoHelper.APP_NAME.equals("weblct")) {
            return;
        }
        this.registry();
        this.startAlarmFreshDevTimer();
        this.registerMOInfo();
    }

    public void stop(BundleContext context) throws Exception {
        this.unregistry();
    }

    public void unregistry() {
        if (this.createRef != null) {
            this.createRef.unregister();
        }
        if (this.deleteRef != null) {
            this.deleteRef.unregister();
        }
        if (this.metaFacrotyRef != null) {
            this.metaFacrotyRef.unregister();
        }
        if (this.translatorFacrotyRef != null) {
            this.translatorFacrotyRef.unregister();
        }
    }

    private void registerMoChangeListeners() {
        MOChangePublisher publisher = MOChangePublisher.getInstance();
        publisher.registry((INotifyListener)new DeviceStatusChangeListener());
        publisher.registry((INotifyListener)new ChassisChangeListener());
        publisher.registry((INotifyListener)new PortChangeListener());
        publisher.registry(new CardChangeListener());
        publisher.registry((INotifyListener)new InnerLinkChangeListener());
    }

    private void registerMOInfo() {
        MOAdditionalInfoMgr.getInstance().addMoPasswordAttrs(CCUTransPack.class, Arrays.asList("password"));
    }

    private void startAlarmFreshDevTimer() {
        LOGGER.info("start AlarmFreshDevTimer.");
        Timer pingTimer = VMFSchedulerFactory.createTimer(AlarmFreshDevTask.class, (boolean)true);
        pingTimer.schedule((TimerTask)new AlarmFreshDevTask(this.inventoryFaultListener), 5000L, 5000L);
        LOGGER.info("end AlarmFreshDevTimer.");
    }
}

