/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.util;

import com.huawei.network.qasn.m_q_common.QAsnIDAndValueInt;
import com.huawei.network.qasn.m_q_common.QAsnIVIList;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.TrunkMemberIfFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkMemberIf;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.atm.QAsnAtmSapTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ethernet.QAsnEthSapTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.DefaultSAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.RemoteApSAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.VBridgeSAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.serial.QAsnSerialSapTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class TranslatorUtil {
    public static final int IPV6_UNKNOW_TYPE = -1;
    private static final String PORT_INTERFACE_MAPPING = "PORT_INTERFACE_MAPPING";
    private static final String TRUNK_INTERFACE_MAPPING = "TRUNK_INTERFACE_MAPPING";

    public static void addTrunkMappingContext(IAsnTranslationContext context, Map<Interface, TrunkIf> mapping) {
        context.addProperty(TRUNK_INTERFACE_MAPPING, mapping);
    }

    public static void encodePortUniResID(Interface inf, QAsnUniResID uid) {
        uid.neID = inf.getDevID();
        uid.strFDN = StringUtil.globalByte((String)inf.getFdn());
        uid.strMOC = null != inf.getFdn() && !inf.getFdn().isEmpty() ? StringUtil.globalByte((String)FDNUtil.getFdnType((String)inf.getFdn())) : StringUtil.globalByte((String)inf.getFdn());
    }

    public static void encodePoSpecialAttr(int id, Integer value, QAsnIVIList poSpecialAttr) {
        if (null == value) {
            return;
        }
        QAsnIDAndValueInt idAndValue = new QAsnIDAndValueInt();
        idAndValue.id = id;
        idAndValue.value = value;
        poSpecialAttr.add((Object)idAndValue);
    }

    public static void encodePoSpecialAttr(int id, Long value, QAsnIVIList poSpecialAttr) {
        if (null == value) {
            return;
        }
        QAsnIDAndValueInt idAndValue = new QAsnIDAndValueInt();
        idAndValue.id = id;
        try {
            idAndValue.value = Integer.valueOf(value.toString());
        }
        catch (Exception e) {
            idAndValue.value = -1;
        }
        poSpecialAttr.add((Object)idAndValue);
    }

    public static void encodeTrunkMemberUniResID(TrunkMemberIf member, QAsnUniResID uid) {
        uid.neID = member.getDevID();
        uid.strFDN = StringUtil.globalByte((String)new TrunkMemberIfFdnParser().getFdn(member));
        uid.strMOC = StringUtil.globalByte((String)InterfaceUtil.getInterfaceFdnType(member.getMemberIfName()));
    }

    public static void encodeTrunkUniResID(TrunkIf trunk, QAsnUniResID uid) {
        uid.neID = trunk.getDevID();
        uid.strFDN = StringUtil.globalByte((String)InterfaceUtil.getTrunkInterfaceFdn(trunk));
        uid.strMOC = StringUtil.globalByte((String)"LP");
    }

    public static List<ISAPTranslator> getAllTranslator() {
        ArrayList<ISAPTranslator> translators = new ArrayList<ISAPTranslator>();
        translators.add(new QAsnEthSapTranslator());
        translators.add(new QAsnAtmSapTranslator());
        translators.add(new QAsnSerialSapTranslator());
        translators.add(new RemoteApSAPTranslator());
        translators.add(new VBridgeSAPTranslator());
        translators.add(new DefaultSAPTranslator());
        return translators;
    }

    public static Port getMappingPort(IAsnTranslationContext context, Interface inf) {
        Map mapping = (Map)context.getProperty(PORT_INTERFACE_MAPPING);
        if (mapping == null) {
            return null;
        }
        return (Port)mapping.get(inf);
    }

    public static TrunkIf getMappingTrunk(IAsnTranslationContext context, Interface inf) {
        Map mapping = (Map)context.getProperty(TRUNK_INTERFACE_MAPPING);
        if (mapping == null) {
            return null;
        }
        return (TrunkIf)mapping.get(inf);
    }
}

