/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.util;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.dao.IRelationMeta;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemChangedUtil {
    private static final Logger logger = LoggerFactory.getLogger(ItemChangedUtil.class);

    public static <C, P> void setItemChangedInList(Collection<C> childInQAsn, Class<C> childType, Class<P> parentType, P parentKey, IAsnTranslationContext context) {
        Context ctext = context.getTransactionContext();
        HashSet<P> parentkeys = new HashSet<P>();
        parentkeys.add(parentKey);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctext);
        try {
            dao.queryByParentKey(childType, parentType, parentkeys);
        }
        catch (VMFException e) {
            logger.debug("queryByParentKey failed!", (Object)e.toString());
        }
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(childType);
        IRelationMeta relation = dao.getRelationMeta(parentType);
        Collection childsInDB = (Collection)relation.getChildren(parentKey, childType);
        if (null == childsInDB) {
            recorder.addCreate(childInQAsn);
            return;
        }
        for (C ch : childInQAsn) {
            if (childsInDB.contains(ch)) {
                recorder.addModify(ch, dao.getPersistentProperties(childType));
                continue;
            }
            recorder.addCreate(ch);
        }
        childsInDB.removeAll(childInQAsn);
        recorder.addDelete(childsInDB);
    }
}

