/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.util;

import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.PosPort;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnPortOAMStatusTranslator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConvertEnumUtil {
    private static Map<Pair<Integer, Integer>, Integer> ethWorkMode = new HashMap<Pair<Integer, Integer>, Integer>();
    private static final int LEVEL_0 = 0;
    private QAsnPortOAMStatusTranslator oamStatusTranslator;

    public static Integer getAutoLAGType(Integer iWorkMode) {
        if (null == iWorkMode) {
            return null;
        }
        if (TrunkIf.WORK_MODE_ENUM.MANUAL.equals(iWorkMode)) {
            return 1;
        }
        if (TrunkIf.WORK_MODE_ENUM.STATIC.equals(iWorkMode)) {
            return 4;
        }
        if (TrunkIf.WORK_MODE_ENUM.BACKUP.equals(iWorkMode)) {
            return 3;
        }
        return null;
    }

    public static Integer getEthWorkMode(EthernetPort port) {
        Integer duplex;
        Integer transMode = port.getTransMode();
        if (null != transMode) {
            if (EthernetPort.TRANS_MODE_ENUM.LAN_MODE.equals(transMode)) {
                return 7;
            }
            if (EthernetPort.TRANS_MODE_ENUM.WAN_MODE.equals(transMode)) {
                return 8;
            }
            return 9;
        }
        Integer negotiation = port.getNegotiation();
        if (EthernetPort.NEGOTIATION_ENUM.ENABLED.equals(negotiation)) {
            return 9;
        }
        Integer speed = port.getSpeed();
        Integer workMode = ethWorkMode.get(new Pair((Object)speed, (Object)(duplex = port.getDuplex())));
        return null == workMode ? 9 : workMode;
    }

    public static Integer getFLoopbackMode(Integer iQLoopBack) {
        if (null == iQLoopBack) {
            return null;
        }
        switch (iQLoopBack) {
            case 2: {
                return Port.LOOPBACK_MODE_ENUM.REMOTE_LOOPBACK;
            }
            case 3: {
                return Port.LOOPBACK_MODE_ENUM.LOCAL_LOOPBACK;
            }
        }
        return Port.LOOPBACK_MODE_ENUM.NO_LOOPBACK;
    }

    public static Boolean getFSupportPrmpt(int iSupportPrmpt) {
        switch (iSupportPrmpt) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return null;
    }

    public static Integer getHashType(int iLoadBalance) {
        switch (iLoadBalance) {
            case 2: {
                return TrunkIf.HASH_TYPE_ENUM.PACKET_ALL;
            }
            case 3: {
                return TrunkIf.HASH_TYPE_ENUM.SOURCEMAC;
            }
            case 4: {
                return TrunkIf.HASH_TYPE_ENUM.DESMAC;
            }
            case 5: {
                return TrunkIf.HASH_TYPE_ENUM.MAC;
            }
            case 6: {
                return TrunkIf.HASH_TYPE_ENUM.SOURCEIP;
            }
            case 7: {
                return TrunkIf.HASH_TYPE_ENUM.DESIP;
            }
            case 8: {
                return TrunkIf.HASH_TYPE_ENUM.IP;
            }
        }
        return null;
    }

    public static Integer getLacpTimeout(Integer rcvTimeoutType) {
        if (null == rcvTimeoutType) {
            return null;
        }
        if (TrunkIf.RCV_TIMEOUT_TYPE_ENUM.FAST.equals(rcvTimeoutType)) {
            return 1;
        }
        if (TrunkIf.RCV_TIMEOUT_TYPE_ENUM.SLOW.equals(rcvTimeoutType)) {
            return 2;
        }
        return null;
    }

    public static Integer getLoadBalanceMode(Integer iHashType) {
        if (null == iHashType) {
            return null;
        }
        if (TrunkIf.HASH_TYPE_ENUM.IP.equals(iHashType)) {
            return 8;
        }
        if (TrunkIf.HASH_TYPE_ENUM.MAC.equals(iHashType)) {
            return 5;
        }
        if (TrunkIf.HASH_TYPE_ENUM.PACKET_ALL.equals(iHashType)) {
            return 2;
        }
        if (TrunkIf.HASH_TYPE_ENUM.DESIP.equals(iHashType)) {
            return 7;
        }
        if (TrunkIf.HASH_TYPE_ENUM.DESMAC.equals(iHashType)) {
            return 4;
        }
        if (TrunkIf.HASH_TYPE_ENUM.SOURCEIP.equals(iHashType)) {
            return 6;
        }
        if (TrunkIf.HASH_TYPE_ENUM.SOURCEMAC.equals(iHashType)) {
            return 3;
        }
        return null;
    }

    public static Integer getMediumType(Integer iType) {
        if (null == iType) {
            return null;
        }
        if (Port.MEDIUM_TYPE_ENUM.COPPER.equals(iType)) {
            return 0;
        }
        if (Port.MEDIUM_TYPE_ENUM.FIBER.equals(iType)) {
            return 1;
        }
        return 0;
    }

    public static Integer getPortMode(EthernetPort port) {
        Integer transMode = port.getTransMode();
        if (null != transMode) {
            if (EthernetPort.TRANS_MODE_ENUM.LAN_MODE.equals(transMode)) {
                return 3;
            }
            if (EthernetPort.TRANS_MODE_ENUM.WAN_MODE.equals(transMode)) {
                return 4;
            }
            return null;
        }
        Integer duplex = port.getDuplex();
        if (EthernetPort.DUPLEX_ENUM.HALF.equals(duplex)) {
            return 1;
        }
        if (EthernetPort.DUPLEX_ENUM.FULL.equals(duplex)) {
            return 2;
        }
        return null;
    }

    public static Integer getPosFClock(int iClock) {
        switch (iClock) {
            case 1: {
                return PosPort.CLOCK_ENUM.MASTER;
            }
            case 2: {
                return PosPort.CLOCK_ENUM.SLAVE;
            }
        }
        return null;
    }

    public static Integer getPosFCrc(int iCrc) {
        switch (iCrc) {
            case 1: {
                return PosPort.CRC_ENUM.CRC_ENUM_16;
            }
            case 2: {
                return PosPort.CRC_ENUM.CRC_ENUM_32;
            }
        }
        return null;
    }

    public static Integer getPosFFrameFormat(int iFrameFormat) {
        switch (iFrameFormat) {
            case 1: {
                return PosPort.FRAME_FORMAT_ENUM.SDH;
            }
            case 2: {
                return PosPort.FRAME_FORMAT_ENUM.SONET;
            }
        }
        return null;
    }

    public static Integer getPosFScramble(int iScramble) {
        switch (iScramble) {
            case 1: {
                return PosPort.SCRAMBLE_ENUM.ENABLED;
            }
            case 2: {
                return PosPort.SCRAMBLE_ENUM.DISABLED;
            }
        }
        return null;
    }

    public static Integer getPosQClock(Integer iClock) {
        if (null == iClock) {
            return null;
        }
        if (PosPort.CLOCK_ENUM.MASTER.equals(iClock)) {
            return 1;
        }
        if (PosPort.CLOCK_ENUM.SLAVE.equals(iClock)) {
            return 2;
        }
        return null;
    }

    public static Integer getPosQCrc(Integer iCrc) {
        if (null == iCrc) {
            return null;
        }
        if (PosPort.CRC_ENUM.CRC_ENUM_16.equals(iCrc)) {
            return 1;
        }
        if (PosPort.CRC_ENUM.CRC_ENUM_32.equals(iCrc)) {
            return 2;
        }
        return null;
    }

    public static Integer getPosQFrameFormat(Integer iFrameFormat) {
        if (null == iFrameFormat) {
            return null;
        }
        if (PosPort.FRAME_FORMAT_ENUM.SDH.equals(iFrameFormat)) {
            return 1;
        }
        if (PosPort.FRAME_FORMAT_ENUM.SONET.equals(iFrameFormat)) {
            return 2;
        }
        return null;
    }

    public static Integer getPosQScramble(Integer iScramble) {
        if (null == iScramble) {
            return null;
        }
        if (PosPort.SCRAMBLE_ENUM.ENABLED.equals(iScramble)) {
            return 1;
        }
        if (PosPort.SCRAMBLE_ENUM.DISABLED.equals(iScramble)) {
            return 2;
        }
        return null;
    }

    public static Integer getQLoopbackMode(Integer iLoopBack) {
        if (null == iLoopBack) {
            return null;
        }
        if (Port.LOOPBACK_MODE_ENUM.REMOTE_LOOPBACK.equals(iLoopBack)) {
            return 2;
        }
        if (Port.LOOPBACK_MODE_ENUM.LOCAL_LOOPBACK.equals(iLoopBack)) {
            return 3;
        }
        return 1;
    }

    public static Integer getQSupportPrmpt(Boolean bSupportPrmpt) {
        if (Boolean.TRUE.equals(bSupportPrmpt)) {
            return 1;
        }
        if (Boolean.FALSE.equals(bSupportPrmpt)) {
            return 2;
        }
        return null;
    }

    public static Integer getRcvTimeoutType(int iLacpTimeout) {
        switch (iLacpTimeout) {
            case 1: {
                return TrunkIf.RCV_TIMEOUT_TYPE_ENUM.FAST;
            }
            case 2: {
                return TrunkIf.RCV_TIMEOUT_TYPE_ENUM.SLOW;
            }
        }
        return null;
    }

    public static Integer getTrunkWorkMode(int iAutoLAGType) {
        switch (iAutoLAGType) {
            case 1: {
                return TrunkIf.WORK_MODE_ENUM.MANUAL;
            }
            case 3: {
                return TrunkIf.WORK_MODE_ENUM.BACKUP;
            }
            case 4: {
                return TrunkIf.WORK_MODE_ENUM.STATIC;
            }
        }
        return null;
    }

    public static void setEthWorkMode(EthernetPort port, int iWorkMode, Collection<String> lstEthPortChg) {
        if (null == port) {
            return;
        }
        switch (iWorkMode) {
            case 7: {
                port.setTransMode(EthernetPort.TRANS_MODE_ENUM.LAN_MODE);
                lstEthPortChg.add("transMode");
                break;
            }
            case 8: {
                port.setTransMode(EthernetPort.TRANS_MODE_ENUM.WAN_MODE);
                lstEthPortChg.add("transMode");
                break;
            }
            case 9: {
                port.setNegotiation(EthernetPort.NEGOTIATION_ENUM.ENABLED);
                lstEthPortChg.add("negotiation");
                break;
            }
            case 1: {
                port.setSpeed(EthernetPort.SPEED_ENUM.SPEED_ENUM_10_M);
                port.setDuplex(EthernetPort.DUPLEX_ENUM.HALF);
                lstEthPortChg.add("speed");
                lstEthPortChg.add("duplex");
                break;
            }
            case 2: {
                port.setSpeed(EthernetPort.SPEED_ENUM.SPEED_ENUM_10_M);
                port.setDuplex(EthernetPort.DUPLEX_ENUM.FULL);
                lstEthPortChg.add("speed");
                lstEthPortChg.add("duplex");
                break;
            }
            case 3: {
                port.setSpeed(EthernetPort.SPEED_ENUM.SPEED_ENUM_100_M);
                port.setDuplex(EthernetPort.DUPLEX_ENUM.HALF);
                lstEthPortChg.add("speed");
                lstEthPortChg.add("duplex");
                break;
            }
            case 4: {
                port.setSpeed(EthernetPort.SPEED_ENUM.SPEED_ENUM_100_M);
                port.setDuplex(EthernetPort.DUPLEX_ENUM.FULL);
                lstEthPortChg.add("speed");
                lstEthPortChg.add("duplex");
                break;
            }
            case 5: {
                port.setSpeed(EthernetPort.SPEED_ENUM.SPEED_ENUM_1000_M);
                port.setDuplex(EthernetPort.DUPLEX_ENUM.HALF);
                lstEthPortChg.add("speed");
                lstEthPortChg.add("duplex");
                break;
            }
            case 6: {
                port.setSpeed(EthernetPort.SPEED_ENUM.SPEED_ENUM_1000_M);
                port.setDuplex(EthernetPort.DUPLEX_ENUM.FULL);
                lstEthPortChg.add("speed");
                lstEthPortChg.add("duplex");
                break;
            }
        }
    }

    public static void setPortMode(EthernetPort port, int iPortMode, Collection<String> lstEthPortChg) {
        if (null == port) {
            return;
        }
        switch (iPortMode) {
            case 1: {
                port.setDuplex(EthernetPort.DUPLEX_ENUM.HALF);
                lstEthPortChg.add("duplex");
                break;
            }
            case 2: {
                port.setDuplex(EthernetPort.DUPLEX_ENUM.FULL);
                lstEthPortChg.add("duplex");
                break;
            }
            case 3: {
                port.setTransMode(EthernetPort.TRANS_MODE_ENUM.LAN_MODE);
                lstEthPortChg.add("transMode");
                break;
            }
            case 4: {
                port.setTransMode(EthernetPort.TRANS_MODE_ENUM.WAN_MODE);
                lstEthPortChg.add("transMode");
                break;
            }
        }
    }

    static {
        ethWorkMode.put((Pair<Integer, Integer>)new Pair((Object)EthernetPort.SPEED_ENUM.SPEED_ENUM_10_M, (Object)EthernetPort.DUPLEX_ENUM.HALF), 1);
        ethWorkMode.put((Pair<Integer, Integer>)new Pair((Object)EthernetPort.SPEED_ENUM.SPEED_ENUM_10_M, (Object)EthernetPort.DUPLEX_ENUM.FULL), 2);
        ethWorkMode.put((Pair<Integer, Integer>)new Pair((Object)EthernetPort.SPEED_ENUM.SPEED_ENUM_100_M, (Object)EthernetPort.DUPLEX_ENUM.HALF), 3);
        ethWorkMode.put((Pair<Integer, Integer>)new Pair((Object)EthernetPort.SPEED_ENUM.SPEED_ENUM_100_M, (Object)EthernetPort.DUPLEX_ENUM.FULL), 4);
        ethWorkMode.put((Pair<Integer, Integer>)new Pair((Object)EthernetPort.SPEED_ENUM.SPEED_ENUM_1000_M, (Object)EthernetPort.DUPLEX_ENUM.HALF), 5);
        ethWorkMode.put((Pair<Integer, Integer>)new Pair((Object)EthernetPort.SPEED_ENUM.SPEED_ENUM_1000_M, (Object)EthernetPort.DUPLEX_ENUM.FULL), 6);
    }
}

