/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.serial;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesLbl;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnLinkProtocol;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.translation.asn.serial.IQAsnStmPortTranslatorExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.CposPort;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1Port;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.StmPort;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.factory.ISAPTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnSapTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.serial.QAsnCposTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.serial.QAsnE1T1Translator;
import com.huawei.vmf.adapter.ifm.translation.asn.serial.QAsnSerialTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QAsnSerialSapTranslator
implements ISAPTranslator {
    private IAsnTranslator<QAsnCesLbl, CposPort> cposTranslator = new QAsnCposTranslator();
    private IAsnTranslator<QAsnCesLbl, E1t1Port> e1t1Translator = new QAsnE1T1Translator();
    private IAsnTranslator<QAsnSAP, Interface> interfaceTranslator = new QAsnSapTranslator();
    private IAsnTranslator<QAsnCesLbl, Interface> serialTranslator = new QAsnSerialTranslator();
    private int PROT_LEVEL_E1 = 1;
    private int PROT_LEVEL_T1 = 3;
    private int PROT_LEVEL_VC4 = 11;
    private Logger logger = LoggerFactory.getLogger(QAsnSerialSapTranslator.class);

    @Override
    public Interface decode(IAsnTranslationContext context, QAsnSAP sap) throws VMFException {
        Interface mo = new Interface();
        this.decode(context, sap, mo);
        return mo;
    }

    @Override
    public void decode(IAsnTranslationContext context, QAsnSAP sap, Interface mo) throws VMFException {
        if (null == sap || null == mo) {
            return;
        }
        this.interfaceTranslator.decode((FStruct)sap, (Object)mo, context);
        if (EOperationType.UNDEPLOY == context.getOperType()) {
            return;
        }
        if ((null == sap.poLinkProtocol || null == sap.poLinkProtocol.poCesCtp) && EOperationType.DELETE != context.getOperType()) {
            return;
        }
        if (null == sap.poLinkProtocol) {
            sap.poLinkProtocol = new QAsnLinkProtocol();
        }
        if (null == sap.poLinkProtocol.poCesCtp) {
            sap.poLinkProtocol.poCesCtp = new QAsnCesCtp();
        }
        if (null == sap.poLinkProtocol.poCesCtp.cesLbl) {
            sap.poLinkProtocol.poCesCtp.cesLbl = new QAsnCesLbl();
        }
        context.addProperty(Interface.class.getName(), (Object)mo);
        int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        if (2049 == ifType) {
            if (InterfaceUtil.isHasStmPortExtPoint()) {
                IQAsnStmPortTranslatorExtPoint stmPortTranslatorExtPoint = (IQAsnStmPortTranslatorExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnStmPortTranslatorExtPoint.class);
                StmPort stmPort = new StmPort();
                stmPortTranslatorExtPoint.decode(sap.poLinkProtocol.poCesCtp.cesLbl, stmPort, context);
                mo.addKeyRefMo((VmfMO)stmPort);
            } else {
                CposPort cposPort = new CposPort();
                this.cposTranslator.decode((FStruct)sap.poLinkProtocol.poCesCtp.cesLbl, (Object)cposPort, context);
                mo.addKeyRefMo((VmfMO)cposPort);
            }
        } else if (128 == ifType) {
            E1t1Port e1t1Port = new E1t1Port();
            this.e1t1Translator.decode((FStruct)sap.poLinkProtocol.poCesCtp.cesLbl, (Object)e1t1Port, context);
            mo.addKeyRefMo((VmfMO)e1t1Port);
        } else if (65543 == ifType) {
            this.serialTranslator.decode((FStruct)sap.poLinkProtocol.poCesCtp.cesLbl, (Object)mo, context);
        }
    }

    @Override
    public QAsnSAP encode(IAsnTranslationContext context, Interface mo) throws VMFException {
        QAsnSAP asn = new QAsnSAP();
        AsnUtil.setDefaultAsnValue((FStruct)asn);
        this.encode(context, mo, asn);
        return asn;
    }

    @Override
    public void encode(IAsnTranslationContext context, Interface mo, QAsnSAP asn) throws VMFException {
        int ifType;
        this.interfaceTranslator.encode((Object)mo, (FStruct)asn, context);
        if (null == asn.poLinkProtocol) {
            asn.poLinkProtocol = new QAsnLinkProtocol();
        }
        asn.poLinkProtocol.type = 4;
        if (null == asn.poLinkProtocol.poCesCtp) {
            asn.poLinkProtocol.poCesCtp = new QAsnCesCtp();
        }
        if (null == asn.poLinkProtocol.poCesCtp.cesLbl) {
            asn.poLinkProtocol.poCesCtp.cesLbl = new QAsnCesLbl();
        }
        if (65543 == (ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName()))) {
            this.serialTranslator.encode((Object)mo, (FStruct)asn.poLinkProtocol.poCesCtp.cesLbl, context);
        } else {
            Class clazz = InterfaceUtil.getCesClass(mo);
            List keyRefMos = mo.getKeyRefMos(clazz);
            if (CollectionUtils.isEmpty((Collection)keyRefMos)) {
                return;
            }
            VmfMO cposOrE1Mo = (VmfMO)keyRefMos.iterator().next();
            if (2049 == ifType) {
                if (InterfaceUtil.isHasStmPortExtPoint()) {
                    IQAsnStmPortTranslatorExtPoint stmPortTranslatorExtPoint = (IQAsnStmPortTranslatorExtPoint)ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnStmPortTranslatorExtPoint.class);
                    stmPortTranslatorExtPoint.encode((StmPort)cposOrE1Mo, asn.poLinkProtocol.poCesCtp.cesLbl, context);
                } else {
                    this.cposTranslator.encode((Object)((CposPort)cposOrE1Mo), (FStruct)asn.poLinkProtocol.poCesCtp.cesLbl, context);
                }
            } else {
                this.e1t1Translator.encode((Object)((E1t1Port)cposOrE1Mo), (FStruct)asn.poLinkProtocol.poCesCtp.cesLbl, context);
            }
        }
        if (InterfaceUtil.isHasStmPortExtPoint()) {
            this.encodePortLevel(mo, asn.poLinkProtocol.poCesCtp, context);
        }
        this.setLinkProtocolChange(asn.poLinkProtocol.poCesCtp.poOperMask, asn);
    }

    private void encodePortLevel(Interface mo, QAsnCesCtp asn, IAsnTranslationContext context) throws VMFException {
        asn.poPortLevel = this.getPortLevel(mo.getIfName());
    }

    private int getPortLevel(String strIfName) {
        if (null != strIfName && strIfName.indexOf("Cpos") >= 0) {
            return this.PROT_LEVEL_VC4;
        }
        if (null != strIfName && strIfName.indexOf("T1") >= 0) {
            return this.PROT_LEVEL_T1;
        }
        this.logger.debug("QAsnSerialSapTranslator getPortLevel do noting.");
        return this.PROT_LEVEL_E1;
    }

    @Override
    public Vector<Integer> getType() {
        Vector<Integer> types = new Vector<Integer>();
        types.add(128);
        types.add(65543);
        if (InterfaceUtil.isHasStmPortExtPoint()) {
            types.add(2049);
            types.add(2050);
            types.add(2051);
        } else {
            types.add(2049);
        }
        return types;
    }

    private void setLinkProtocolChange(Integer poOperMask, QAsnSAP asn) {
        if (null != poOperMask && poOperMask > 0) {
            if (null == asn.poOperMask) {
                asn.poOperMask = new Integer(0);
            }
            asn.poOperMask = asn.poOperMask | 4;
        }
    }
}

