/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.serial;

import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesLbl;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.ChannelSet;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1Port;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnE1T1Translator
extends AbstractAsnTranslator<QAsnCesLbl, E1t1Port> {
    public void decode(QAsnCesLbl asn, E1t1Port mo, IAsnTranslationContext context) throws VMFException {
        Interface ifmo = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(ifmo.getDevID());
        mo.setVrID(ifmo.getVrID());
        String position = InterfaceUtil.getPositionFromInterfaceName(ifmo.getIfName());
        mo.setPosition(position);
        ArrayList<ChannelSet> channelSets = new ArrayList<ChannelSet>();
        ChannelSet channelSet = new ChannelSet();
        channelSet.setDevID(mo.getDevID());
        channelSet.setVrID(mo.getVrID());
        channelSet.setPosition(mo.getPosition());
        channelSet.setSetNumber(Long.valueOf(this.longValue(asn.channelSetID)));
        String timeslotList = InterfaceUtil.getStringFromSequenceOfInt((List)asn.timeSlotList);
        timeslotList = InterfaceUtil.isFrame(timeslotList) ? timeslotList : "0-31";
        channelSet.setTimeslotList(timeslotList);
        channelSets.add(channelSet);
        Integer workMode = InterfaceUtil.isFrame(timeslotList) ? E1t1Port.WORK_MODE_ENUM.FRAMED : E1t1Port.WORK_MODE_ENUM.UNFRAMED;
        mo.setWorkMode(workMode);
        mo.addChannelSets(channelSets);
    }

    public void encode(E1t1Port mo, QAsnCesLbl asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo) {
            return;
        }
        Collection channelSets = mo.getChannelSets();
        if (CollectionUtils.isEmpty((Collection)channelSets)) {
            return;
        }
        ChannelSet channelSet = (ChannelSet)channelSets.iterator().next();
        asn.channelSetID = this.intValue(channelSet.getSetNumber());
        String timeslotListStr = channelSet.getTimeslotList();
        if (!InterfaceUtil.isFrame(channelSet.getTimeslotList())) {
            return;
        }
        ArrayList timeslotList = InterfaceUtil.parseSlot(timeslotListStr);
        asn.timeSlotList = new QAsnTinyIntList();
        for (Integer timeslot : timeslotList) {
            asn.timeSlotList.add((Object)timeslot);
        }
    }

    public Class<QAsnCesLbl> getAsnClass() {
        return QAsnCesLbl.class;
    }

    public Class<E1t1Port> getMoClass() {
        return E1t1Port.class;
    }
}

