/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.serial;

import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnCesLbl;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.CposChannel;
import com.huawei.vmf.adapter.fservice.ifm.model.CposPort;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QAsnCposTranslator
extends AbstractAsnTranslator<QAsnCesLbl, CposPort> {
    public void decode(QAsnCesLbl asn, CposPort mo, IAsnTranslationContext context) throws VMFException {
        Interface ifmo = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(ifmo.getDevID());
        mo.setVrID(ifmo.getVrID());
        String position = InterfaceUtil.getPositionFromInterfaceName(ifmo.getIfName());
        mo.setPosition(position);
        ArrayList<E1t1> e1t1s = new ArrayList<E1t1>();
        E1t1 e1t1 = new E1t1();
        e1t1.setDevID(mo.getDevID());
        e1t1.setVrID(mo.getVrID());
        e1t1.setPosition(mo.getPosition());
        e1t1.setE1t1Number(Long.valueOf(this.longValue(asn.lowPath)));
        ArrayList<CposChannel> cposChannels = new ArrayList<CposChannel>();
        CposChannel cposChannel = new CposChannel();
        cposChannel.setDevID(mo.getDevID());
        cposChannel.setVrID(mo.getVrID());
        cposChannel.setPosition(mo.getPosition());
        cposChannel.setE1t1Number(e1t1.getE1t1Number());
        cposChannel.setSetNumber(Long.valueOf(this.longValue(asn.channelSetID)));
        String timeslotList = InterfaceUtil.getStringFromSequenceOfInt((List)asn.timeSlotList);
        timeslotList = InterfaceUtil.isFrame(timeslotList) ? timeslotList : "0-31";
        cposChannel.setTimeslotList(timeslotList);
        cposChannels.add(cposChannel);
        Integer workMode = InterfaceUtil.isFrame(timeslotList) ? E1t1.WORK_MODE_ENUM.FRAMED : E1t1.WORK_MODE_ENUM.UNFRAMED;
        e1t1.setWorkMode(workMode);
        e1t1.addCposChannels(cposChannels);
        e1t1s.add(e1t1);
        mo.addE1t1s(e1t1s);
    }

    public void encode(CposPort mo, QAsnCesLbl asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo) {
            return;
        }
        Collection e1t1s = mo.getE1t1s();
        if (CollectionUtils.isEmpty((Collection)e1t1s)) {
            return;
        }
        E1t1 e1t1 = (E1t1)e1t1s.iterator().next();
        asn.lowPath = this.intValue(e1t1.getE1t1Number());
        Collection cposChannels = e1t1.getCposChannels();
        if (CollectionUtils.isEmpty((Collection)cposChannels)) {
            return;
        }
        CposChannel cposChannel = (CposChannel)cposChannels.iterator().next();
        asn.channelSetID = this.intValue(cposChannel.getSetNumber());
        String timeslotListStr = cposChannel.getTimeslotList();
        if (!InterfaceUtil.isFrame(cposChannel.getTimeslotList())) {
            return;
        }
        ArrayList timeslotList = InterfaceUtil.parseSlot(timeslotListStr);
        asn.timeSlotList = new QAsnTinyIntList();
        for (Integer timeslot : timeslotList) {
            asn.timeSlotList.add((Object)timeslot);
        }
    }

    public Class<QAsnCesLbl> getAsnClass() {
        return QAsnCesLbl.class;
    }

    public Class<CposPort> getMoClass() {
        return CposPort.class;
    }
}

