/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm.spec;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnEthCtp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.extendpoint.ifm.util.InterfaceSapInfoExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.service.InterfaceService;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnSapTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.util.CollectionUtils;

public class QAsnSAPSpecTranslator
extends AbstractAsnSpecTranslator<QAsnSapTranslator> {
    public void decodeAutopickSapID(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (-1 != asn.autopickSapID) {
            mo.setAutopickSapID(Integer.valueOf(asn.autopickSapID));
        }
    }

    public void decodeDeployStatus(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (EOperationType.PREDEPLOY.equals((Object)context.getOperType())) {
            mo.setDeployStatus(Integer.valueOf(0));
        }
    }

    public void decodeDescription(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        String strDesc = StringUtil.globalString((byte[])asn.description);
        if (null != strDesc && !strDesc.equals("")) {
            mo.setIfDescr(strDesc);
        }
    }

    public void decodeEnableStatus(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (-1 == asn.enableStatus) {
            return;
        }
        mo.setIfAdminStatus(Integer.valueOf(asn.enableStatus));
    }

    public void decodeKeyProperties(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        mo.setSerialNum(StringUtil.globalString((byte[])asn.ctpKey.poSerialNum));
        Interface moIndex = fdnParser.getIndexMo(StringUtil.globalString((byte[])asn.ctpKey.strFDN));
        Interface moMainPort = fdnParser.getIndexMo(StringUtil.globalString((byte[])asn.mainPortFdn));
        if (null != asn.ctpKey.poSerialNum && null != moMainPort.getIfName() && InterfaceUtil.isMainInterface(moMainPort.getIfName())) {
            if (null == moMainPort) {
                this.getLogger().error("mainPortfdn is null or subIfNum is null!");
                return;
            }
            Interface newSubIf = null;
            String ifName = moMainPort.getIfName();
            if (null != asn.subIFNo) {
                String subIfNum = String.valueOf(asn.subIFNo);
                ifName = ifName + "." + subIfNum;
            } else {
                Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
                if (null != interfaceUtilExtPoint && this.isHasVlanID(asn)) {
                    InterfaceService ifService = new InterfaceService();
                    ArrayList<Interface> mainMos = new ArrayList<Interface>();
                    mainMos.add(moMainPort);
                    try {
                        Iterator<Interface> i$;
                        Collection<Interface> subMos = ifService.allocSubIf(mainMos);
                        if (null != subMos && (i$ = subMos.iterator()).hasNext()) {
                            Interface subIf = i$.next();
                            subIf = this.getSubIfInfoForVlanID(subIf, asn);
                            Integer iIfType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)subIf.getIfName());
                            subIf.setiQIfType(iIfType);
                            newSubIf = subIf;
                            ifName = subIf.getIfName();
                        }
                    }
                    catch (VMFException e) {
                        this.getLogger().debug("QAsnSAPSpecTranslator decodeKeyProperties getSubIfNo failed : " + (Object)((Object)e));
                    }
                }
            }
            Interface tmpMo = new Interface();
            tmpMo.setDevID(moMainPort.getDevID());
            tmpMo.setVrID(moMainPort.getVrID());
            tmpMo.setIfName(ifName);
            String fdn = fdnParser.getFdn(tmpMo);
            Interface subIfMo = fdnParser.getIndexMo(fdn);
            if (null != newSubIf) {
                newSubIf.setFdn(fdn);
                subIfMo = newSubIf;
            }
            mo.setDevID(subIfMo.getDevID());
            mo.setVrID(subIfMo.getVrID());
            mo.setIfName(subIfMo.getIfName());
            mo.setIfPhyType(subIfMo.getIfPhyType());
            mo.setiQIfType(subIfMo.getiQIfType());
            mo.setIfParentIfName(subIfMo.getIfParentIfName());
            mo.setIfNumber(subIfMo.getIfNumber());
            mo.setFdn(subIfMo.getFdn());
        } else {
            mo.setDevID(moIndex.getDevID());
            mo.setVrID(moIndex.getVrID());
            mo.setIfName(moIndex.getIfName());
            mo.setIfPhyType(moIndex.getIfPhyType());
            mo.setiQIfType(moIndex.getiQIfType());
            mo.setIfParentIfName(moIndex.getIfParentIfName());
            mo.setIfNumber(moIndex.getIfNumber());
            mo.setFdn(moIndex.getFdn());
        }
    }

    public void decodeMtu(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (-1 == asn.mtu) {
            return;
        }
        mo.setIfMtu(Integer.valueOf(asn.mtu));
    }

    public void decodePhysicalType(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        int iType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        mo.setiQIfType(Integer.valueOf(iType));
    }

    public void decodePoSpeed(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == asn.poSpeed || AsnUtil.parseLong((byte[])asn.poSpeed) == AsnUtil.parseLong((byte[])"-1".getBytes())) {
            return;
        }
        mo.setIfOperSpeed(AsnUtil.parseLong((byte[])asn.poSpeed));
    }

    public void decodeRunningStatus(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (-1 == asn.runningStatus) {
            return;
        }
        mo.setIfOperStatus(Integer.valueOf(asn.runningStatus));
    }

    public void decodeSubIFNo(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null != asn.subIFNo && !asn.subIFNo.equals(-1)) {
            mo.setIfNumber(String.valueOf(asn.subIFNo.longValue()));
        }
    }

    public void encodeAutopickSapID(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        asn.autopickSapID = mo.getAutopickSapID();
    }

    public void encodeDeployStatus(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        asn.deployStatus = mo.getDeployStatus();
    }

    public void encodeDescription(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == mo.getIfDescr() || mo.getIfDescr().isEmpty()) {
            return;
        }
        asn.description = mo.getIfDescr().getBytes();
    }

    public void encodeEnableStatus(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == mo.getIfAdminStatus()) {
            return;
        }
        Object interfaceSapExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(InterfaceSapInfoExtPoint.class);
        if (interfaceSapExtPoint != null) {
            boolean isContinue = false;
            try {
                isContinue = ((InterfaceSapInfoExtPoint)interfaceSapExtPoint).isSupportIfmEnableStatus();
            }
            catch (Exception e) {
                this.getLogger().error("failed new instance for ITaskSpecialAction!", (Throwable)e);
            }
            if (!isContinue) {
                asn.enableStatus = -1;
                return;
            }
        }
        asn.enableStatus = mo.getIfAdminStatus();
    }

    public void encodeKeyProperties(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        String strFdn = fdnParser.getFdn(mo);
        asn.ctpKey.strFDN = StringUtil.globalByte((String)strFdn);
        asn.ctpKey.strMOC = StringUtil.globalByte((String)FDNUtil.getFdnType((String)strFdn));
        asn.ctpKey.neID = mo.getDevID();
        asn.ctpKey.poSerialNum = AsnUtil.getBytes((String)mo.getSerialNum());
    }

    public void encodeMainPortFdn(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (!InterfaceUtil.isMainInterface(mo.getIfName()) && null != mo.getIfParentIfName()) {
            Interface parentMo = new Interface();
            parentMo.setDevID(mo.getDevID());
            parentMo.setVrID(mo.getVrID());
            parentMo.setIfName(mo.getIfParentIfName());
            InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
            String fdn = interfaceFdnParser.getFdn(parentMo);
            asn.mainPortFdn = AsnUtil.getBytes((String)fdn);
        }
    }

    public void encodeMtu(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == mo.getIfMtu()) {
            return;
        }
        asn.mtu = mo.getIfMtu();
    }

    public void encodePoSpeed(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == asn.poSpeed) {
            asn.poSpeed = new byte[0];
        }
        asn.poSpeed = String.valueOf(mo.getIfOperSpeed()).getBytes();
    }

    public void encodeRunningStatus(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == mo.getIfOperStatus()) {
            return;
        }
        asn.runningStatus = mo.getIfOperStatus();
    }

    public void encodeSubIFNo(QAsnSAP asn, Interface mo, IAsnTranslationContext context) {
        if (null == mo.getIfNumber() || InterfaceUtil.isMainInterface(mo.getIfName())) {
            return;
        }
        asn.subIFNo = Integer.valueOf(mo.getIfNumber());
    }

    private Interface getSubIfInfoForVlanID(Interface subIf, QAsnSAP asn) {
        Integer vlanID = this.getVlanID(asn);
        if (null == vlanID) {
            return subIf;
        }
        Interface mo = new Interface();
        mo.setDevID(subIf.getDevID());
        mo.setVrID(subIf.getVrID());
        String ifName = subIf.getIfParentIfName() + "." + vlanID;
        mo.setIfName(ifName);
        ArrayList<Interface> ifMos = new ArrayList<Interface>();
        ifMos.add(mo);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> ifClazz = ((Interface)ifMos.iterator().next()).getClass();
        Collection resIfs = null;
        try {
            resIfs = dao.queryByKey(ifClazz, ifMos, false);
        }
        catch (VMFException e) {
            this.getLogger().debug("QAsnSAPSpecTranslator getSubIfInfoForVlanID query subIf fail: " + (Object)((Object)e));
        }
        if (CollectionUtils.isEmpty((Collection)resIfs)) {
            subIf.setIfName(ifName);
            subIf.setIfNumber(vlanID.toString());
        }
        return subIf;
    }

    private Integer getVlanID(QAsnSAP asn) {
        Integer VlanID = null;
        if (null != asn.poLinkProtocol && null != asn.poLinkProtocol.poEthCtp) {
            QAsnEthCtp ethCtp = asn.poLinkProtocol.poEthCtp;
            if (null != ethCtp.poEthVlan && null != ethCtp.poEthVlan.vlanIDList && !ethCtp.poEthVlan.vlanIDList.isEmpty()) {
                VlanID = Integer.valueOf(ethCtp.poEthVlan.vlanIDList.iterator().next().toString());
            }
        }
        return VlanID;
    }

    private boolean isHasVlanID(QAsnSAP asn) {
        boolean result = false;
        if (null != asn.poLinkProtocol && null != asn.poLinkProtocol.poEthCtp) {
            QAsnEthCtp ethCtp = asn.poLinkProtocol.poEthCtp;
            if (null != ethCtp.poEthVlan && null != ethCtp.poEthVlan.vlanIDList && !ethCtp.poEthVlan.vlanIDList.isEmpty()) {
                result = true;
            }
        }
        return result;
    }
}

