/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm.spec;

import com.huawei.network.qasn.m_q_interface_model.QAsnPortDetailInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.StmPort;
import com.huawei.vmf.adapter.ifm.translation.asn.ifm.QAsnPortDetailInfoTranslator;
import com.huawei.vmf.adapter.ifm.translation.asn.util.TranslatorUtil;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnPortDetailInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnPortDetailInfoTranslator> {
    public void decodePortIndex(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
    }

    public void decodeWorkMode(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) {
        ArrayList<String> lstChg = new ArrayList<String>();
        int iOper = asn.operBit;
        if (0 < (iOper & 0x100)) {
            if (1025 == mo.getiQIfType() || 65539 == mo.getiQIfType()) {
                if (50 == asn.workMode) {
                    mo.setIsL2SwitchPort(Boolean.valueOf(true));
                } else {
                    mo.setIsL2SwitchPort(Boolean.valueOf(false));
                }
                lstChg.add("isL2SwitchPort");
            }
            IMOChangeRecord moChangeRecord = context.getTransactionContext().addChangeRecord(Interface.class);
            moChangeRecord.addModify((Object)mo, lstChg);
        }
    }

    public void encodePortIndex(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) throws VMFException {
        if (mo == null || asn == null || context == null) {
            return;
        }
        TranslatorUtil.encodePortUniResID(mo, asn.portIndex);
        asn.userLabel = new byte[0];
        asn.owner = new byte[0];
        asn.level = 0;
        asn.direction = -1;
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
        asn.channelizedType = null != interfaceUtilExtPoint ? this.getStmPortPortChannelization(mo) : -1;
        asn.boardName = new byte[0];
        asn.subCardName = new byte[0];
    }

    private Integer getStmPortPortChannelization(Interface mo) {
        Integer result = -1;
        if (null == mo || null == mo.getIfPosition() || mo.getIfPosition().isEmpty() || 2049 != mo.getiQIfType()) {
            return result;
        }
        ArrayList<StmPort> moIndexs = new ArrayList<StmPort>();
        StmPort stmPortindex = new StmPort();
        stmPortindex.setDevID(mo.getDevID());
        stmPortindex.setVrID(mo.getVrID());
        stmPortindex.setPosition(mo.getIfPosition());
        moIndexs.add(stmPortindex);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection stmData = null;
        try {
            stmData = dao.queryByKey(StmPort.class, moIndexs, true);
            if (!CollectionUtils.isEmpty((Collection)stmData) && null == (result = ((StmPort)stmData.iterator().next()).getPortChannelization())) {
                result = -1;
            }
        }
        catch (VMFException e) {
            this.getLogger().error("getStmPortPortChannelization is fail!" + (Object)((Object)e));
        }
        return result;
    }

    public void encodeWorkMode(QAsnPortDetailInfo asn, Interface mo, IAsnTranslationContext context) {
        if (1025 == mo.getiQIfType() || 65539 == mo.getiQIfType()) {
            asn.workMode = !Boolean.TRUE.equals(mo.getIsL2SwitchPort()) ? 51 : 50;
        } else if (65549 == mo.getiQIfType()) {
            Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
            if (null != interfaceUtilExtPoint) {
                asn.workMode = !Interface.VE_TYPE_ENUM.L2_VE.equals(mo.getVeType()) ? 51 : 50;
            }
        } else {
            asn.workMode = 2049 == mo.getiQIfType() ? (mo.getIfPhyType().toLowerCase().equals("Cpos".toLowerCase()) ? 20 : 19) : (65559 == mo.getiQIfType() ? 51 : -1);
        }
    }
}

