/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.translation.asn.ifm.spec;

import com.huawei.network.qasn.m_q_ip_link_model.QAsnIPInterface;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.OnlyEncodeAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnGetIPInterfaceTranslator
extends OnlyEncodeAsnTranslator<QAsnIPInterface, Interface> {
    private static final int DISABLEIPV6 = 2;
    private static final int ENABLEIPV6 = 1;
    private static final int ISIPV4ADDRNO = 0;
    private static final int ISIPV4ADDRYES = 1;
    private static final int ISIPV6ADDRNO = 0;
    private static final int ISIPV6ADDRYES = 1;

    public void encode(Interface inf, QAsnIPInterface asn, IAsnTranslationContext context) throws VMFException {
        QAsnIPInterface asnObj = asn;
        this.setDefaultAsnValue((FStruct)asnObj);
        asnObj.resID.neID = inf.getDevID();
        asnObj.resID.strFDN = this.getBytes(InterfaceUtil.getInterfaceFdn(inf.getDevID(), inf.getVrID(), inf.getIfName()));
        asnObj.iEnableIpv6 = null != inf.getIpv6Enable() && inf.getIpv6Enable() != false ? 1 : 2;
        asnObj.isIpv4Addr = this.encodeIsIpv4(inf);
        asnObj.isIpv6Addr = this.encodeIsIpv6(inf);
    }

    protected int encodeIsIpv4(Interface inf) {
        return !CollectionUtils.isEmpty((Collection)inf.getIpv4Addresss()) ? 1 : 0;
    }

    protected int encodeIsIpv6(Interface inf) {
        return !CollectionUtils.isEmpty((Collection)inf.getIpv6Addresss()) ? 1 : 0;
    }

    public Class<QAsnIPInterface> getAsnClass() {
        return QAsnIPInterface.class;
    }

    public Class<Interface> getMoClass() {
        return Interface.class;
    }
}

